#ifndef BUILDER_H
#define BUILDER_H

namespace MM
{
class Atom;
class Bond;
class Distance_restraint;
class Order;
class Molecule;
class Residue;
class Joint;
class Model;

class Builder
{
public:
    virtual                         ~Builder() {}

    virtual Atom &                  new_atom 
                                        (Model & model, 
                                         Element element) const =0;

    virtual Bond &                  new_bond 
                                        (Model &       model,
                                         Atom &        atom1,
                                         Atom &        atom2,
                                         Order const & order) const =0;

    virtual Distance_restraint &    new_distance_restraint 
                                        (Model &      model,
                                         Atom &       atom1,
                                         Atom &       atom2,
                                         Text const & type,
                                         double       R_eqv,
                                         double       K_r) const =0;

    virtual Molecule &              new_molecule (Model & model) const =0;
    virtual Residue  &              new_residue  (Model & model) const =0;

    virtual Joint &                 new_joint
                                        (Model & model, 
                                         Atom  & stub_atom,
                                         Atom  & terminal_atom,
                                         Atom  & directional_atom) const =0;
};

}//MM

#endif //BUILDER_H
