#ifndef HYPERCHEM_FILE_H
#define HYPERCHEM_FILE_H

#ifndef MODEL_FILE_H
#include "Model_file.h"
#endif

namespace MM
{

class Molecule;
class Molecular_iterator;
class Text_output;

class Hyperchem_file : public Model_file
{
    static Hyperchem_file   prototype_;

public:
    explicit            Hyperchem_file (Prototype const &);
    explicit            Hyperchem_file (Model & model);
    virtual Model_file *clone (Model & model) const;

    virtual bool        support_input     () const {return true;}
    virtual bool        support_output    () const {return true;}
    virtual bool        support_bonds     () const {return true;}
    virtual bool        support_molecules () const {return true;}

    virtual Text const& type_name () const {static Text t("HyperChem"); return t;}
    virtual void        save            (bool to_comment);
    virtual void        check_file_name ();
    virtual void        add             (Text const & file_name);

private:
    void                write_molecule( const Molecule & molecule, 
                                        int              molecule_number, 
                                        Text_output &    out );

    void                write_atom    (const Atom & atom, int atom_number, Text_output & out);

    //Molecular_iterator  create_molecular_iterator();
};

}//MM

#endif //HYPERCHEM_FILE_H
