#include "Test.h"

#include "ID.h"
#include "Bond.h"
#include "Atom_impl.h"
#include "Path.h"
#include "Model.h"
#include "Create.h"

namespace MM
{
class Hyperchem_file;

class Hyperchem_test : public Test
{
    Hyperchem_file    *link;

public:
    Hyperchem_test( const Text & suite_name ) : Test( suite_name ) { }

    void run()
    {
        test_read_file();    count_tests();
    }
    void test_read_file()
    {
        Own <Model> model   (prototype <Model>().clone());
        Own <Model> model_2 (prototype <Model>().clone());

//        model  (). load (Text(DIR_tests) + "bad.hin");
        model  (). load    (Path::tests()         + "C20.hin");
        model  (). save_as (Path::tests_rubbish() + "C20.hin" );
        model_2(). load    (Path::tests_rubbish() + "C20.hin");

        TEST ("", model().atom_count () == (20 + 40 + 2)); //62
        TEST ("", model().atom_count () == model_2().atom_count ());
        TEST ("", model().bond_count () == (40 + 20 + 1));
        TEST ("", model().bond_count () == model_2().bond_count ());

        TEST ("", model().atom (0).bound_count() == 4);
        TEST ("", model().atom (0).bound(0).element() == Element("C"));
        TEST ("", model().atom (0).bond (0).order  () == Order  ('s'));
        TEST ("", model().atom (0).bound(1).element() == Element("H"));
        TEST ("", model().atom (0).bound(2).element() == Element("H"));
        TEST ("", model().atom (0).bound(3).element() == Element("H"));
    }
};

Hyperchem_test test_hyperchem ("correctness");

}//MM
