#include "Test.h"

#include "ID.h"
#include "Bond.h"
#include "Atom_impl.h"
#include "Path.h"
#include "Model.h"
#include "Create.h"

namespace MM
{
class Pdb_file;

class Pdb_test : public Test
{
    Pdb_file    *link;

public:
    Pdb_test( const Text & suite_name ) : Test( suite_name ) { }

    void run()
    {
        test1_read_pdb_file();    count_tests();
    }
    void test1_read_pdb_file();
    void test_read_residue();

};

Pdb_test test_pdb ("correctness");

void Pdb_test::
test1_read_pdb_file()
{
//    Janitor< MM_model > model( factory().make_molecular_model() );

//    model().load   ( Text(DIR_tests)         + "1crn.pdb" );
//    model().save_as( Text(DIR_tests_rubbish) + "1crn.xyz" );
//    model().save_as( Text(DIR_tests_rubbish) + "1crn.ent" );

	//fix
    //TEST( "", k_methane_model( model ) );//*/

    Own <Model> model (prototype <Model>().clone());

    model().load    (Path::tests()         + "1crn.pdb");
    model().save_as (Path::tests_rubbish() + "1crn.xyz");
    model().save_as (Path::tests_rubbish() + "1crn.ent");
//*/
	//fix
    //TEST( "", k_methane_model( model ) );//*/
}

void Pdb_test::
test_read_residue()
{
/*
    char *sequence[] = {
    "THR","THR","CYS","CYS","PRO","SER","ILE","VAL","ALA","ARG","SER","ASN","PHE",
    "ASN","VAL","CYS","ARG","LEU","PRO","GLY","THR","PRO","GLU","ALA","ILE","CYS",
    "ALA","THR","TYR","THR","GLY","CYS","ILE","ILE","ILE","PRO","GLY","ALA","THR",
    "CYS","PRO","GLY","ASP","TYR","ALA","ASN" };

    Janitor< MM_model > model( factory().make_molecular_model() );

    model().load( Text(DIR_tests) + "1crn.pdb" );

//    Array_of < Residue > & residues = model().residues();
    Chain chain( model() );

//    for (int ii=0;ii<residues.size();++ii)
//    {
//        TEST ("",residues[ii].name() == Text( sequence[ii] ) );
//    }
    Array_of < Residue > residue = chain.residue();
    for (int ii=0; ii<residue.size(); ++ii)
    {
        TEST ("",residue[ii].name() == Text( sequence[ii] ) );
    }//*/
}

}//MM
