#ifndef STORABLE_H
#define STORABLE_H

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef MODEL_FILE_H
#include "Model_file.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{
class Text;
class Model_file;
class Model;

class Storable : protected DbC
{
    Model &                 model_;
    //Model_file *			original_file_;
    Own <Model_file>        current_file_;

public:
    explicit                Storable   (Model &);
    virtual                ~Storable() { }

    bool                    was_defined () const;
    Text                    file_name () const;
    Text                    extension () const;

    Model &                 model   ()  {return model_;}

    virtual bool            save    (bool to_comment = false);
    virtual bool            save_as (Text const & file_name,
                                     Text const & file_type = "auto detect",
                                     Text *       name_saved = 0,
                                     bool         to_comment = false);
    virtual void            load    (Text const & file_name,
                                     Text const & file_type = "auto detect");
    virtual void            add     (Text const & file_name,
                                     Text const & file_type = "auto detect",
                                     bool         is_loading = false);
    virtual void            pull_on (Text const & file_name,
                                     Text const & file_type = "auto detect");
    //virtual void            clear   ();

private:
    Text const &            detect_file_type   (Text const & file_name, 
                                                Text *       extension = 0);
    void                    setup_current_file (Text const & file_type);
};

}//MM

#endif //STORABLE_H
