#ifndef XYZ_FILE_H
#define XYZ_FILE_H

#ifndef MODEL_FILE_H
#include "Model_file.h"
#endif

namespace MM
{

class Xyz_file : public Model_file
{
    static Xyz_file         prototype_;

public:    
    explicit                Xyz_file (Prototype const &);
    explicit                Xyz_file (Model & model);
    virtual Model_file *    clone (Model & model) const;

    virtual bool            support_input     () const {return true;}
    virtual bool            support_output    () const {return true;}
    virtual bool            support_bonds     () const {return false;}
    virtual bool            support_molecules () const {return false;}

    virtual Text const &    type_name () const {static Text t("XYZ"); return t;}
    virtual void            save            (bool to_comment);
    virtual void            check_file_name ();
    virtual void            add             (Text const & file_name);
};

}//MM

#endif //XYZ_FILE_H
