#include "Composite_lattice_presentation.h"

namespace MM
{

Lattice_presentation * Composite_lattice_presentation::
clone () const
{
    Composite_lattice_presentation *result
        = new Composite_lattice_presentation();

    for (int i=0;  i<presentation_.size();  ++i)
    {
        result->add (*presentation_[i]); //fix *
    }

    return result;
}

void Composite_lattice_presentation::
add (Lattice_presentation & presentation)
{
    presentation_.push_back (&presentation);
}

void Composite_lattice_presentation::
set_lattice (Lattice & lattice)
{
    for (int i=0;  i<presentation_.size();  ++i)
    {
        presentation_[i]->set_lattice (lattice);
    }
}

void Composite_lattice_presentation::
show ()
{
    for (int i=0;  i<presentation_.size();  ++i)
    {
        presentation_[i]->show ();
    }
}

void Composite_lattice_presentation::
full_update ()
{
    for (int i=0;  i<presentation_.size();  ++i)
    {
        presentation_[i]->full_update ();
    }
}

}//MM
