#include "Composite_table_presentation.h"

namespace MM
{

Table_presentation * Composite_table_presentation::
clone () const
{
    Composite_table_presentation *result
        = new Composite_table_presentation();

    for (int i=0;  i<presentation_.size();  ++i)
    {
        result->add (*presentation_[i]); //fix *
    }

    return result;
}

void Composite_table_presentation::
add (Table_presentation & presentation)
{
    presentation_.push_back (&presentation);
}

void Composite_table_presentation::
set_table (Table & table)
{
    for (int i=0;  i<presentation_.size();  ++i)
    {
        presentation_[i]->set_table (table);
    }
}

void Composite_table_presentation::
show ()
{
    for (int i=0;  i<presentation_.size();  ++i)
    {
        presentation_[i]->show ();
    }
}

void Composite_table_presentation::
full_update ()
{
    for (int i=0;  i<presentation_.size();  ++i)
    {
        presentation_[i]->full_update ();
    }
}

}//MM
