#include "Lattice.h"

#include "Line.h"

namespace MM
{

void Lattice::
get_column (int i, Line & column)
{
    REQUIRE ("Input line has enough length.", column.length() >= height());
    int size = height();

    for (int row = 0;   row < size;   ++row)
        column[row] = cell (row, i);
}

void Lattice::
get_row (int i, Line & row)
{
    REQUIRE ("Input line has enough length.", row.length() >= width());
    int size = width();

    for (int column = 0;   column < size;   ++column)
        row[column] = cell (i, column);
}

Lattice::~Lattice(){}

}//MM
