#ifndef LATTICE_H
#define LATTICE_H

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef ANY_H
#include "Any.h"
#endif

namespace MM
{

class Line;
class Text;

class Lattice : protected DbC
{
    /** @link dependency */

/*# Line lnkLine; */

public:
    virtual ~Lattice();
    virtual Any             operator () (int row, int column);
    virtual Any             cell        (int row, int column) = 0;
    virtual void            get_text    (int row, int column, Text & text) = 0;
    virtual int             height      ()  const = 0;
    virtual int             width       ()  const = 0;
    virtual void            get_row     (int i, Line & row);
    virtual void            get_column  (int i, Line & column);

    virtual void            clear () =0;
    virtual void            adopt (Line * record) =0;
};


inline Any Lattice::
operator () (int row, int column)
{
    return cell(row, column);
}

} //MM

#endif //LATTICE_H

