#ifndef LATTICE_PRESENTATION_FRAME_H
#define LATTICE_PRESENTATION_FRAME_H

#ifndef LATTICE_PRESENTATION_H
#include "Lattice_presentation.h"
#endif

namespace MM
{

class Lattice;

class Lattice_presentation_frame : public Lattice_presentation
{
    Lattice             *lattice_;

public:
    Lattice_presentation_frame() : lattice_(0) { }
    Lattice &           lattice ()              {INVARIANT; return *lattice_;}
    const Lattice &     lattice () const        {INVARIANT; return *lattice_;}
    virtual void        set_lattice (Lattice & lattice) {lattice_ = &lattice;}
    bool                lattice_was_initialized() const  {return lattice_ != 0;}

protected:
    virtual bool        invariant() const   {return lattice_was_initialized();}
};

}//MM

#endif //LATTICE_PRESENTATION_FRAME_H
