#ifndef TABLE_H
#define TABLE_H

#ifndef LATTICE_H
#include "Lattice.h"
#endif

namespace MM
{

class Table : public Lattice
{
public:
    virtual bool            has_row_labels    ()=0;
    virtual bool            has_column_labels ()=0;
    virtual const Text &    row_label       (int row   ) const=0;
    virtual const Text &    column_label    (int column) const=0;
    virtual void            set_row_label   (int row,    const Text & label)=0;
    virtual void            set_column_label(int column, const Text & label)=0;

    virtual Table *         clone () const =0;
    virtual Line *          create_line () const =0;

    virtual void            new_column (const Text & name)=0; 
};

}//MM

#endif //TABLE_H
