#ifndef TABLE_IMPL_H
#define TABLE_IMPL_H

//#ifndef LATTICE_H
//#include "Lattice.h"
//#endif

#ifndef TABLE_H
#include "Table.h"
#endif

#ifndef LINE_H
#include "Line.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

#ifndef ARRAY_OF_OBJ_H
#include "Array_of_obj.h"
#endif

namespace MM
{

class Table_impl : public Table
{
    //Line                       *record_prototype_;     //fix ???
    Own <Line>                  record_prototype_;
    Array_of_own <Line>         row_;                   //fix to Line
    Array_of_obj <Text>         row_label_;
    Array_of_obj <Text>         column_label_;

public:    
    explicit                    Table_impl (Line * prototype);
                                ~Table_impl();
    Table *                     clone () const;
    Line *                      create_line () const;

    void                        clear () ;

    void                        new_column (const Text & name);
    void                        adopt (Line * record);

    // Lattice interface
    virtual Any                 cell     (int row, int column);
    virtual int                 height   () const;
    virtual int                 width    () const;
    virtual void                get_text (int row, int column,
                                          Text & text);//fix remove
    // Table interface
    virtual bool                has_row_labels    ();
    virtual bool                has_column_labels ();
    virtual const Text &        row_label       (int row) const;
    virtual const Text &        column_label    (int column) const;
    virtual void                set_row_label   (int row,
                                                 const Text & label);
    virtual void                set_column_label(int column, const
                                                 Text & label);
};

inline Any Table_impl::
cell (int row, int column)
{
    REQUIRE ("In range", row<height() && column<width());
    return row_[row][column];
}

inline int Table_impl::
height () const
{
    return row_.size();
}

inline int Table_impl::
width () const
{
    //return row_[0]->length();
//    return column_label_.size();
    return record_prototype_().length();
}

}//MM

#endif //TABLE_IMPL_H

