#include "Test.h"

#include "Table_from_file.h"
#include "Line_impl.h"
#include "Text_file_table_presentation.h"
#include "Path.h"
#include "Any.h"

//#include "Log.h"

#include <string>

namespace MM
{

class Table_test : public Test
{
public:
    Table_test (const Text& suite_name) : Test (suite_name) { }

    void run()
    {
        test_make_table ();   count_tests();
        test_read_file  ();   count_tests();
    }

    void test_make_table()
    {
        Line_impl *column_types = new Line_impl;
        column_types->add (int());
        column_types->add (double());
        column_types->add (float());
        column_types->add (std::string());

        Table_impl table (column_types);
        Line_impl *line;

        line = new Line_impl;
        line->add (111);
        line->add (1.2345);
        line->add (5.4321f);
        line->add (std::string("first line"));
        table.adopt (line);

        line = new Line_impl;
        line->add (222);
        line->add (1.2345);
        line->add (5.4321f);
        line->add (std::string("second line"));
        table.adopt (line);

        TEST ("", any_cast <int>         (table.cell(0,0)) == 111);
        TEST ("", any_cast <double>      (table.cell(0,1)) == 1.2345);
        TEST ("", any_cast <float>       (table.cell(0,2)) == 5.4321F);
        DOUBLES_EQUAL (any_cast <float>  (table.cell(0,2)), 5.4321, 0.0001);
        TEST ("", any_cast <std::string> (table.cell(0,3)) == "first line");

        TEST ("", any_cast <int>         (table(1,0)) == 222);
        TEST ("", any_cast <double>      (table(1,1)) == 1.2345);
        TEST ("", any_cast <float>       (table(1,2)) == 5.4321F);
        TEST ("", any_cast <std::string> (table(1,3)) == "second line");

        Text_file_table_presentation file 
            (Path::tests_rubbish() + "test table.txt");
        file.set_table (table);
        file.full_update ();
    }
                                                                                
    void test_read_file()
    {
        Line_impl *column_types = new Line_impl;
        column_types->add (std::string());
        column_types->add (int());
        column_types->add (double());
        column_types->add (float());
        column_types->add (std::string());

        Table_from_file table 
            (Path::tests_rubbish() + "test table.txt", column_types);

        TEST ("", any_cast <std::string> (table.cell(0,0)) == "#0");
        TEST ("", any_cast <int>         (table.cell(0,1)) == 111);
        TEST ("", any_cast <double>      (table.cell(0,2)) == 1.2345);
        TEST ("", any_cast <float>       (table.cell(0,3)) == 5.4321F);
        DOUBLES_EQUAL (any_cast <float>  (table.cell(0,3)), 5.4321, 0.0001);
        TEST ("", any_cast <std::string> (table.cell(0,4)) == "first line");

        TEST ("", any_cast <std::string> (table.cell(1,0)) == "#1");
        TEST ("", any_cast <int>         (table(1,1)) == 222);
        TEST ("", any_cast <double>      (table(1,2)) == 1.2345);
        TEST ("", any_cast <float>       (table(1,3)) == 5.4321F);
        TEST ("", any_cast <std::string> (table(1,4)) == "second line");//*/
    }

private:        
    /** @link dependency */
    /*#  Table_from_file lnkTable_from_file; */
};

Table_test test_table ("correctness");

}//MM
