#ifndef TEXT_FILE_TABLE_PRESENTATION_H
#define TEXT_FILE_TABLE_PRESENTATION_H

#ifndef TEXT_TABLE_PRESENTATION_H
#include "Text_table_presentation.h"
#endif

#ifndef FILE_TEXT_OUTPUT_H
#include "File_text_output.h"
#endif

namespace MM
{
class Text_output;

class Text_file_table_presentation : public Text_table_presentation
{
    Text                        file_name_;
    Own <File_text_output>      file_text_output_;

public:
    virtual Table_presentation * clone () const
    {
        FIX;
        return (Table_presentation*)0;
    }

    Text_file_table_presentation (const Text & file_name)
    :
        file_name_(file_name),
        file_text_output_(new File_text_output(file_name))
    {
        set_output (file_text_output_());
    }

    virtual void full_update ()
    {
        File_text_output *out = file_text_output_.orphan();
        delete out;
        file_text_output_.adopt (new File_text_output (file_name_));
        set_output (file_text_output_());
        Text_table_presentation::full_update ();
    }
};

}//MM

#endif //TEXT_FILE_TABLE_PRESENTATION_H
