#include "Text_lattice_presentation.h"

#include "Table.h"
#include "Text_output.h"
#include "Flaw.h"

#include <string>

namespace MM
{

Lattice_presentation * Text_lattice_presentation::
clone () const
{
    Text_lattice_presentation *twin = new Text_lattice_presentation ();

    if (output_was_initialized()) 
        twin->set_output (const_cast <Text_output&> (output ()));

    if (lattice_was_initialized())
        twin->set_lattice (const_cast <Lattice&> (lattice ()));

    return twin;
}

void Text_lattice_presentation::
set_output(Text_output & out)
{
    out_ = &out;
}

void Text_lattice_presentation::
show ()
{
    full_update ();
}

void Text_lattice_presentation::
full_update ()
{
    INVARIANT;

    int height = lattice().height();
    int width  = lattice().width ();

    for (int row=0;  row<height;  ++row)
    {
        for (int column = 0;  column < width;  ++column)
        {
            Text text;
            lattice().get_text (row, column, text);
            out_->text (text.c_str());

            if (column == width-1) break;

            out_->text ("\t");
        }
        out_->line ("");
        out_->flush ();
    }
}

Text_lattice_presentation::
Text_lattice_presentation ()
:
    out_ (0)
{
}

}//MM
