#ifndef TEXT_LATTICE_PRESENTATION_H
#define TEXT_LATTICE_PRESENTATION_H

#ifndef LATTICE_PRESENTATION_FRAME_H
#include "Lattice_presentation_frame.h"
#endif

namespace MM
{

class Text_output;

class Text_lattice_presentation : public Lattice_presentation_frame
{
    Text_output     *out_;

public:
    Text_lattice_presentation ();
    virtual Lattice_presentation *  clone () const;
    virtual void                    set_output(Text_output & out);
    bool                            output_was_initialized() const  {return out_ != 0;}
    Text_output &                   output ()                       {return *out_;}
    const Text_output &             output () const                 {return *out_;}
    virtual void                    show ();
    virtual void                    full_update ();

protected:
    virtual bool        invariant() const
    {
        return     Lattice_presentation_frame::invariant()
                && output_was_initialized();
    }
};

}//MM

#endif //TEXT_LATTICE_PRESENTATION_H
