#include "Text_table_presentation.h"

#include "Table.h"
#include "Text_output.h"

namespace MM
{

Table_presentation * Text_table_presentation::
clone () const
{
    Text_table_presentation *twin = new Text_table_presentation ();

    if (output_was_initialized()) 
        twin->set_output (const_cast <Text_output&> (output ()));

    if (table_was_initialized())
        twin->set_table (const_cast <Table&> (table ()));

    return twin;
}

void Text_table_presentation::
set_output(Text_output & out)
{
    out_ = &out;
}

void Text_table_presentation::
show ()
{
    full_update ();
}

void Text_table_presentation::
full_update ()
{
    INVARIANT;

    int row, column;
    int height = table().height();
    int width  = table().width ();

    if (table().has_column_labels())
    {
        if (table().has_row_labels())
        {
            out_->text ("Table");
            out_->text ("\t");
        }

        for (column = 0;  column < width;  ++column)
        {
            out_->text (table().column_label (column));

            if (column == width-1) break;
            out_->text ("\t");
        }
        out_->line ("");
        out_->flush ();
    }

    for (row = 0;  row < height;  ++row)
    {
        if (table().has_row_labels())
        {
            out_->text (table(). row_label(row));
            out_->text ("\t");
        }

        for (column = 0;  column < width;  ++column)
        {
            Text text;
            table().get_text (row, column, text);
            out_->text (text);

            if (column == width-1) break;

            out_->text ("\t");
        }
        out_->line ("");
        out_->flush ();
    }
}

Text_table_presentation::
Text_table_presentation ()
:
    out_ (0)
{
}

}//MM



