// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#include "DbC.h"

#include "Log.h"

namespace MM
{

void DbC::
require( const Text &  assertion,
         bool          condition,
         const Text &  condition_String,
         const Text &  file,
         int           line ) const
{
    examine_invariant( "Invariant    ", invariant(), file, line );
    examine( "Precondition ", assertion, condition, condition_String,
             file, line );
}

void DbC::
ensure( const Text &  assertion,
        bool          condition,
        const Text &  condition_String,
        const Text &  file,
        int           line ) const
{
    examine_invariant( "Invariant    ", invariant(), file, line );
    examine( "Postcondition", assertion, condition, condition_String,
             file, line );
}

void DbC::
check(  const Text &  assertion,
        bool          condition,
        const Text &  condition_String,
        const Text &  file,
        int           line ) const
{
    examine( "Check        ", assertion, condition, condition_String,
             file, line );
}

void DbC::
examine_invariant(  const Text &  type,
                    bool          condition,
                    const Text &  file,
                    int           line ) const
{
    if( !condition )
    {
        Text result = type + " violation:\n" +
                        "in " + file + ", line " + line + "\n";

        log() << "\n" << result;
        throw Contract_violation( result );
    }
}

void DbC::
examine( const Text &  type,
         const Text &  assertion,
         bool          condition,
         const Text &  condition_String,
         const Text &  file,
         int           line ) const
{
    if( !condition )
    {
        Text result = type + " violation:\n" +
                        assertion + "\n("+condition_String+"),\n" +
                        "in "  + file + ", line " + line + "\n";

        log() << "\n" << result;
        throw Contract_violation( result );
    }
}

}//MM

