// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifdef WIN32
#pragma warning (disable : 4996)
#endif

#include "Flaw.h"

#include "Log.h"
#include <time.h>

namespace MM
{

Flaw::Flaw( Text text )
{
    time_t time_ = time( 0 );
    message_ =  text + ", " + asctime( localtime( &time_ ) );
    log() << "\n\n!!! Flaw:\n" << message_ << "\n\n";
}

const Text & Flaw::
message() const
{
    return message_;
}

}//MM

