#ifndef GRID_3D_H
#define GRID_3D_H

#ifndef ARRAY_H
#include "Array.h"
#endif

namespace MM
{

template <typename T>
class Grid_3D : public  Array <T>
{
    int     x_size_, y_size_, z_size_;

public:
    Grid_3D (int x, int y, int z) : x_size_(x), y_size_(y), z_size_(z) {}
    Grid_3D () : x_size_(0), y_size_(0), z_size_(0) {}
   ~Grid_3D () {x_size_ = -1; y_size_ = -1; z_size_ = -1;}

    void    resize (int x, int y, int z)
    {
        this->clear ();

        x_size_ = x;    
        y_size_ = y;    
        z_size_ = z;
        
        int size = x*y*z;
        
        for (int i=0;  i<size;  ++i)
            push_back (T());
    }

    T &         operator () (int i, int j, int k)
    {
        //return this->operator [] (x_size_*y_size_*i + x_size_*j + k);
        return this->operator [] (i + j*x_size_ + k*x_size_*y_size_);
    }

    T const&    operator () (int i, int j, int k) const
    {
//        return this->operator [] (x_size_*y_size_*i + x_size_*j + k);
        return this->operator [] (i + j*x_size_ + k*x_size_*y_size_);
    }

    int         x_size () const {return x_size_;}  
    int         y_size () const {return y_size_;}  
    int         z_size () const {return z_size_;}  
};

}//MM

#endif //GRID_3D_H
