#ifndef LOCK_H
#define LOCK_H

#ifndef USER_H
#include "User.h"
#endif

namespace MM
{

template <typename T>
class Lock
{
    T &         obj_;
    bool        flag_;

public:
    explicit    Lock (T & obj) 
        : obj_(obj), flag_(true) 
    {
        try
        {
            if (obj_.locked ())
                flag_ = false;
            else
                obj_.set_lock (true); 
        }
        catch(...) {to_user().fatal_error ("Lock::Lock"); throw;}
    }
    virtual    ~Lock ()
    {
        try
        {
            if (flag_)
                obj_.set_lock (false);
        }
        catch(...) {to_user().fatal_error ("Lock::~Lock"); throw;}
    }
};

}//MM

#endif //LOCK_H
