#ifndef MISTAKE_H
#define MISTAKE_H

#define MISTAKE throw Mistake( __FILE__, __LINE__ )

#ifndef LOG_H
#include "log.h"
#endif

#ifndef TEXT_H
#include "text.h"
#endif

//namespace MM
//{

class Mistake
{
public:

    Mistake( char * file, int line )
    {
        time_t time_ = time( 0 );

        message_ = Text() + "Mistake: " + file + ", line " + line + ", " +
                   asctime( localtime( &time_ ) ) + "\n";

        logger() << message_.c_str();
    }

    const std::string message() { return message_.c_str(); }

private:
    Text  message_;
};

//}//MM

#endif//MISTAKE_H

