#include "Path.h"

#include "Create.h"
#include "Application.h"
//#include "Graphic_configuration.h"

namespace MM
{

namespace Path
{

char * start_dir ()
{
    static char instance [1024];
    return      instance;
}

Text 
prefix ()
{
#if defined (MM_CORE)
    return home ();
#else
    #if defined(MM_WIN32)
        return home () + ("src\\MolMeccano\\");
    #else
        return home () + ("src/MolMeccano/");
    #endif
#endif
}

Text &
home ()  
{

    static Text win32 ("..\\");
    static Text unix_home  ("../");

#if defined(MM_WIN32)
    return win32;
#else
    return unix_home;
#endif
}

Text
full_home ()
{
    int size = strlen (start_dir());
    char home_dir [1024];
    strncpy (home_dir, start_dir(), size-3); // - bin
    home_dir[size-3] = '\0';
    return home_dir; 
}

#if defined(MM_WIN32)
    //Text working                     () {return Text(start_dir()) + "\\";}
    Text working                     () {return home() + "Work\\";}
    Text bin                         () {return home() + "bin\\";}
    Text doc                         () {return home() + "doc\\";}
    Text data                        () {return home() + "data\\";}
    Text MDynaMix                    () {return home() + "MDynaMix\\";}
    Text MDynaMix_database           () {return home() + "MDynaMix\\moldb\\";}
    Text CP2K                        () {return home() + "CP2K\\";}
    Text GAMESS                      () {return home() + "GAMESS\\";}
    Text Firefly                     () {return home() + "Firefly\\";}
    Text NWChem                      () {return full_home() + "nwchem\\";}
    Text NWChem_bin                  () {return full_home() + "nwchem\\bin\\";}
    Text report                      () {return home() + "Report\\";}

    Text images                      () {return data() + "Images\\";}
    Text kernels                     () {return data() + "Kernels\\";}
    Text nano                        () {return data() + "Nano\\";}
    //Text bin                         () {return ".\\";}
    Text aminoacids_billets          () {return data() + "Repository\\- Amino Acids\\Aminoacids\\Billets\\";}
    Text aminoacids                  () {return data() + "Repository\\- Amino Acids\\";}
    Text aminoacids_20               () {return data() + "Repository\\- Amino Acids\\Aminoacids\\20\\";}
    Text aminoacids_tinker           () {return data() + "Repository\\- Amino Acids\\tinker\\";}
    Text repository                  () {return data() + "Repository\\";}
    Text parameters                  () {return data() + "Parameters\\";}
    Text protocol                    () {return data() + "Protocols\\";}
    Text icon                        () {return data() + "Icon\\";}
    Text tests                       () {return data() + "Tests\\";}
    Text tests_rubbish               () {return data() + "TestsRubbish\\";}
    Text force_field                 () {return data() + "ForceField\\";}
#else
    //Text working                     () {return Text(start_dir()) + "/";}
    Text working                     () {return home() + "Work/";}
    Text bin                         () {return home() + "bin/";}
    Text doc                         () {return home() + "doc/";}
    Text data                        () {return home() + "data/";}
    Text MDynaMix                    () {return home() + "MDynaMix/";}
    Text MDynaMix_database           () {return home() + "MDynaMix/moldb/";}
    Text CP2K                        () {return home() + "CP2K/";}
    Text GAMESS                      () {return home() + "GAMESS/";}
    Text Firefly                     () {return home() + "Firefly/";}
    Text NWChem                      () {return home() + "nwchem/";}
    Text NWChem_bin                  () {return home() + "nwchem/bin/";}
    Text report                      () {return home() + "Report/";}

    Text images                      () {return data() + "Images/";}
    Text kernels                     () {return data() + "Kernels/";}
    Text nano                        () {return data() + "Nano/";}

//Text bin                         () {return "./";}
    Text aminoacids_billets          () {return data() + "Repository/- Amino Acids/Aminoacids/Billets/";}
    Text aminoacids                  () {return data() + "Repository/- Amino Acids/";}
    Text aminoacids_20               () {return data() + "Repository/- Amino Acids/Aminoacids/20/";}
    Text aminoacids_tinker           () {return data() + "Repository/- Amino Acids/tinker/";}
    Text repository                  () {return data() + "Repository/";}
    Text parameters                  () {return data() + "Parameters/";}
    Text protocol                    () {return data() + "Protocols/";}
    Text icon                        () {return data() + "Icon/";}
    Text tests                       () {return data() + "Tests/";}
    Text tests_rubbish               () {return data() + "TestsRubbish/";}
    Text force_field                 () {return data() + "ForceField/";}
#endif

}//Path

}//MM
