#ifndef PROXY_H
#define PROXY_H

namespace MM
{

template <class T>
class Proxy
{
    T * obj_;
public:
    explicit Proxy <T> (T * obj) : obj_(obj) {}

    T *         operator -> ()          {return obj_;}
    T const *   operator -> () const    {return obj_;}
};

inline template <class T> Proxy <T> *
proxy (T * obj)
{
    return new Proxy<T> (obj);
}

}//MM

#endif //PROXY_H
