#ifndef REFERENCE_COUNTED_H
#define REFERENCE_COUNTED_H

#ifndef DBC_H
#include "DbC.h"
#endif

//fix memory leaks

class Reference_counted : protected MM::DbC
{
    int                     count_;

public:
    Reference_counted ()                           : count_(0)  { }
//    Reference_counted (const Reference_counted & ) : count_(0), DbC()  { }
    Reference_counted (const Reference_counted & ) : DbC(), count_(0) { }
    Reference_counted & operator = (const Reference_counted &)  {return *this;}
    void                    kill()                              {delete this;}//fix

    virtual void            add_reference()                     {++count_;}
    virtual void            release_reference()
    {
        REQUIRE ("Object was referenced.", count_>0);
        if(--count_==0)
            delete this;
    }

protected:
    /** Prevent object creation out of the heap. */
    virtual ~Reference_counted () ;
};

#endif //REFERENCE_COUNTED_H

