#ifndef STRONG_POINTER_H
#define STRONG_POINTER_H


template < class T >
class Strong_pointer
{
    T *     pointee_;

public:
    Strong_pointer( T * adoptee )
        : pointee_( adoptee )               { pointee_->add_reference(); }

    Strong_pointer( const Strong_pointer< T > & h )
        : pointee_( h.pointee_ )            { pointee_->add_reference(); }

    ~Strong_pointer()                       { pointee_->release_reference(); }

    const Strong_pointer< T > &   operator = ( const Strong_pointer< T > & h )
    {
        if( this     == & h        )    return * this;
        if( pointee_ == h.pointee_ )    return * this;
        pointee_->release_reference();
        pointee_ = h.pointee_;
        pointee_->add_reference();
        return * this;
    }

                            operator T* () { return pointee_; }
    T *                     operator -> () { return pointee_; }

    /*T *                 orphan()
    {
        invariant();
        T *tmp = p_;
        p_ = 0;
        return  tmp;
    }
    void                adopt( T * adoptee )
    {
        p_ = adoptee;
    }//*/
};

#endif //STRONG_POINTER_H



