#ifndef TEXT_H
#define TEXT_H

#ifdef MM_QT 
class QString; 
#endif 

namespace MM
{

/**
Class Text is an analog of std::string.

It allow manipulate by text information easily.
But it is not replacement for std::string.
Class Text is very inefficient. And it was done intentionally.
The purpose is to provide a comfortable tool for
creation of warnings, error messages, captions and etc.
Every program has a lot of such string.
Class std::string is not very convenient for this purpose
so that it operate with text informaiton only.
It is desirable to have a class that help to
create strings form char*, int, double etc.
Directive "#include <string>" add a greate volume of text,
that lead to significant compilation speed degradation.
Class Text is very small.

So, it's a good idea to write something like:

if( obj_ptr == 0 )
    throw Text("Awful error in ") + typeid(*this).name() + " !";

In contrast, this is a really bad idea:

ofstream out( filename );
for( int i=0;  i<1000000;  ++i )
{
    out << Text( i ) + ... ;
    ...
}

In such case std::string should be used.
*/


class Text
{
    char                    *buf_;
    int                     buf_size_;

public:
/*    typedef char*           iterator;
    typedef const char*     const_iterator;

    iterator            begin()         { return buf_; }
    const_iterator      begin() const   { return buf_; }
    iterator            end  ()         { return buf_+buf_size_; } //fix
    const_iterator      end  () const   { return buf_+buf_size_; }
//*/ 
   ~Text ();
    Text ();
    Text (Text const &   text);
    Text (const char *   text);
    Text (bool           text);
    Text (char           text);  
    Text (short          text);
    Text (int            text);
    Text (long           text);
    Text (unsigned short text);
    Text (unsigned int   text);
    Text (unsigned long  text);
    Text (float          text);
    Text (double         text);
    Text (double         text, int precision);
    Text (long double    text);
    Text (void *         text);

#ifdef MM_QT 
    Text (QString text);
    operator QString () const;
#endif

    bool                is_empty () const;
    bool                is_not_empty () const {return !is_empty ();}

    int                 size   (void) const;
    int                 length (void) const;

    const Text &        operator =  (const  Text & text);
    const Text &        operator += (const  Text & text);

    friend Text         operator +  (const Text & l, const Text & r);
    friend bool         operator == (const Text & l, const Text & r);
    friend bool         operator != (const Text & l, const Text & r);
    friend bool         operator <  (const Text & l, const Text & r);
    friend bool         operator >  (const Text & l, const Text & r);

    char               operator [] (int i) const;
    char &              operator [] (int i);
    const char *        c_str    () const;
    Text                to_upper () const;
    Text                to_lower () const;
    int                 to_int   () const;
    double              to_double   () const;

    void                clear   ();
    void                realloc (int new_size);
};


inline Text operator + (const Text & l, const Text & r)
{
    return Text (l) += r;
}

}//MM

#endif//TEXT_H

