#include "Test.h"

#include "Log.h"
#include "Array.h"

#include <vector>

namespace MM
{

class Text_test : public Test
{
public:
    Text_test( const Text & suite_name ) : Test( suite_name ) { }
    
    void run()
    {
        test_text   ();     count_tests();
        test_numbers();     count_tests();
        test_upper  ();     count_tests();
        test_array  ();     count_tests();
        test_copy   ();     count_tests();
    }

    void test_text    ();
    void test_numbers ();
    void test_upper   ();
    void test_array   ();
    void test_copy    ();
};

Text_test test_text ("correctness");

void Text_test::
test_text ()
{
    Text text;
    TEST ("Test class Text", text == "");

    Text text1( "Test text 1" );
    TEST ("Test text 1", text1 == "Test text 1");

    Text text2( text1 );
    TEST ("Test text 2", text2 == "Test text 1");

    Text text3 = text2;
    TEST ("Test text 3", text3 == "Test text 1");

    Text text4 = text3;
    TEST ("Test text 4", text4 == "Test text 1");

    Text text5;
    text5 = text4;
    TEST ("Test text 5", text5 == "Test text 1");

    Text text6;
    text6 = "Test text 6";
    TEST ("Test text 6", text6 == "Test text 6");

//    const std::string  text7 = "std::string";
//    TEST( "Test std::string", text7 == "std::string" );

//    std::string  text8;
//    text8 = "std::string";
//    TEST( "Test std::string", text8 == "std::string" );

//    const char        text9[] = "char*";
//    TEST( "Test char*", std::string( text9 ) == "char*" );

    text += text1;
    text += Text( "+=" );
    TEST ("+=", text == "Test text 1+=");
    TEST ("operator []", text[4] == ' ' && text[0] == 'T');
}

void Text_test::
test_numbers ()
{
    bool            _bool           = false;
    char            _char           = 'a';
    short           _short          = 1;
    int             _int            = 2;
    long            _long           = 3;
    unsigned short  _unsigned_short = 4;
    unsigned int    _unsigned_int   = 5;
    unsigned long   _unsigned_long  = 6;
    float           _float          = float(7.7);
    double          _double         = 8.8;
    long double     _long_double    = 9.9;
    void           *_void           = (void*)0x11110000;

    Text text = Text() + _bool + _char + _short + _int + _long 
        + _unsigned_short + _unsigned_int + _unsigned_long + " " 
        + _float + " " + _double + " " + _long_double + " " + _void;

    TEST ("Numbers", text == "falsea123456 7.7 8.8 9.9 11110000" ||
                     text == "falsea123456 7.7 8.8 9.9 0x11110000");
    TEST ("Length" , text.size() == 33 || text.size() == 35);
}

void Text_test::
test_upper ()
{
    Text text ("Test text 123 .,/\\");
    Text new_text = text.to_upper ();
    TEST ("Upper", new_text == "TEST TEXT 123 .,/\\");

    new_text = text.to_lower ();
    TEST ("Lower", new_text == "test text 123 .,/\\");
}

void Text_test::
test_array ()
{
    std::vector  <Text> vect;
    vect.push_back ("One");
    vect.push_back ("Two");

    TEST ("", vect[0] == "One");
    TEST ("", vect[1] == "Two");
    TEST ("", vect.size() == 2);

    std::vector <Text> vect_copy = vect;

    TEST ("", vect_copy[0] == "One");
    TEST ("", vect_copy[1] == "Two");
    TEST ("", vect_copy.size() == 2);

    ///////////////////////////////////

    Array<Text> array;
    array.push_back ("One");
    array.push_back ("Two");

    TEST ("", array[0] == "One");
    TEST ("", array[1] == "Two");
    TEST ("", array.size() == 2);

    Array <Text> copy = array;

    TEST ("", copy[0] == "One");
    TEST ("", copy[1] == "Two");
    TEST ("", copy.size() == 2);

}

void Text_test::
test_copy ()
{
    Text t1 = "t";
    {
        Text t2 = t1;
        t2 += 2;
    }
    TEST ("", t1 == "t");
}

}//MM
