#ifndef WEAK_POINTER_H
#define WEAK_POINTER_H

template < class T >
class Weak_pointer
{
    T *     pointee_;

public:
    Weak_pointer( T * p )
        : pointee_( p )                         { }

    Weak_pointer( const Weak_pointer< T > & h )
        : pointee_( h.pointee_ )                { }

    ~Weak_pointer()                             { }

    const Weak_pointer< T > &   operator = ( const Weak_pointer< T > & h )
    {
        if( this     == & h        )    return * this;
        if( pointee_ == h.pointee_ )    return * this;
        pointee_ = h.pointee_;
        return * this;
    }

                            operator T* () { return pointee_; }
    T *                     operator -> () { return pointee_; }
};

#endif //WEAK_POINTER_H
