#ifndef STRING_REPLACE_H
#define STRING_REPLACE_H

#include <string>

// From: Thore Karlsen

// Replace all occurences of a substring in a string with another
// string, in-place.
  
// @param s String to replace in. Will be modified.
// @param sub Substring to replace.
// @param other String to replace substring with.
  
// @return The string after replacements.

inline std::string &
string_replace (std::string &s, 
                std::string const & sub, 
                std::string const & other)
{
    size_t b = 0;
    for (;;)
    {
        b = s.find (sub, b);
        if (b == s.npos) 
            break;

        s.replace (b, sub.size(), other);
        b += other.size ();
    }
    return s;
}

#endif STRING_REPLACE_H
