#include "Text_view.h"

#include "Atom.h"
#include "Bond.h"
#include "Model.h"
#include "Text_output.h"
#include "Log.h"

namespace MM
{

Text_view::
Text_view (Model & subject, const Model & model,Text_output & output)
: 
    View( subject ), model_( model ), output_( output ) 
{
}

void Text_view::update(bool /*rebuild*/) //fix
{
	int i;

    output_.line("");
    output_.line("#   Stream_view update.");
    output_.text(Text("#   ")+model_.atom_count()+" atoms     ");

    for( i=0;  i<model_.atom_count(); ++i )
    {
//        output_.text(Text(model_.atoms().current().element().c_str())+" ");
        Text text = Text(model_.atom(i).element().c_str())+" ";
        //logger() << text;
        output_.text( text );
    }
    output_.line("");

    output_.text(Text(model_.bond_count())+" bonds     ");

    for( i=0;  i<model_.bond_count();  ++i )
    {
        const Atom_group & bond = model_.bond(i);

        for (int j=0;  j<bond.atom_count();  ++j)
        {
            Text text = Text (bond.atom(j).element().c_str());
            output_.text (text);
        }

        output_.text (" ");
    }

    output_.line ("");
}

}//MM
