#!/usr/bin/perl
#
#
# Copyright (C) 1997-2009, R3vis Corporation.
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA, or visit http://www.gnu.org/copyleft/lgpl.html.
#
# Original Contributor:
#   Wes Bethel, R3vis Corporation, Marin County, California
#   http://www.r3vis.com/
# Additional Contributor(s):
#
# The OpenRM project is located at http://openrm.sourceforge.net/.
# 
#

# usage: sortlist fname.old fname.new dir_prefix
#
# the input file is assumed to be the index file produced by the
# script source2perl.pl. this script will sort the contents of
# that file, then process it, stripping out extra junk (the keys
# used for sorting) and beautifies it a little bit.
#
# $Id: sortlist.pl,v 1.4 2008/11/24 16:51:34 wes Exp $
# Version: $Name: v180-alpha-02 $
# $Revision: 1.4 $
# $Log: sortlist.pl,v $
# Revision 1.4  2008/11/24 16:51:34  wes
# Replaced ormsg.gif with ormsg.png
#
# Revision 1.3  2005/02/19 16:47:58  wes
# Distro sync and consolidation.
#
# Revision 1.2  2004/01/17 04:04:18  wes
# Updated copyright line for 2004.
#
# Revision 1.1.1.1  2003/01/28 02:15:23  wes
# Manual rebuild of rm150 repository.
#
# Revision 1.4  2001/06/04 00:59:41  wes
# Added RMI to list of subdirs.
#
# Revision 1.3  2000/10/03 11:42:06  wes
# Usage line update (jdb).
#
# Revision 1.2  2000/04/20 16:13:10  wes
# JDB modifications for building docs.
#
# Revision 1.1.1.1  2000/02/28 21:29:40  wes
# OpenRM 1.2 Checkin
#
# Revision 1.1.1.1  2000/02/28 17:18:48  wes
# Initial entry - pre-RM120 release, source base for OpenRM 1.2.
#
#

# variables 
$tempFName = ""; 
$tempName = "tempfile-deleteme"; 

%info = (rmaux => ["librmaux.html", 0, 0, "RMAUX provides user
         interface and window interface functionality.  Herein lies
         the platform-specific window implementation details, hidden
         by the RMpipe abstraction.  Support for several typical user
         interface techniques is also included here."],

         rm => ["librm.html", 0, 0, "RM is the core library of the
         OpenRM Scene Graph.  It handles all of the details and
         functionality of the scene graph: nodes, primitives,
         geometry, rendering parameters, and scene parameters.  This
         are the \"guts\", as it were, of the OpenRM Scene Graph."],

	 rmv => ["librmv.html", 0, 0, "RMV provides a library of
	 routines for building scientific visualization applications
	 with OpenRM.  A variety of 2D and 3D techniques are
	 implemented with support for scalar and vector fields.  These
	 include iconic or glyph-based techniques as well as
	 contouring and isosurfacing."],

	 rmi => ["librmi.html", 0, 0, "RMI contains routines to read
         and write many popular raster image formats."]);


# begin of main()
{
    # sort the file on <library> and <name> keys together (ascending)
    $tempFName = $ARGV[2] . "/" . $ARGV[0];
    system("sort -t \"<\" $tempFName > $tempName");

    # next, process the tempfile, writing the results into a new file
    open (inFile, "<$tempName") or die "ERROR: cannot open the input temporary index file.";
    my $lib = "";
    my $link = "";

    while ($line = <inFile>) # scan the sorted temp index
    {
	@fields = split(/\s+/, $line);
	$lib = $fields[0];
	$line =~ /$fields[1] /;
	$link = $';

	if ($fields[1] =~ /RM/) # datatype
	{
	    ${$lib . "Data"}->[$info{$lib}[1]] = $link;
	    $info{$lib}[1]++;
        }
	else # function
	{
	    ${$lib . "Func"}->[$info{$lib}[2]] = $link;
            $info{$lib}[2]++;
	}
    }
    close inFile;
    system("\\rm $tempName");

    # output the processed file as individual library documents
    for $i (keys %info)
    {
        $tempFName = $ARGV[2] . "/" . $info{$i}[0];
	open(outFile, ">$tempFName") or die "ERROR: cannot open the output index file ", $info{$i}[0];

	# output header stuff (assume at least one public datatype or function
        print outFile "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n";
        print outFile "<html><head><title>Index of OpenRM - lib", $i, " Library</title></head>\n";
        print outFile "<body bgcolor=white fgcolor=black> \n<table width=\"100%\" border=2 cellspacing=0 cellpadding=0 bgcolor=\"khaki\" valign=\"center\">\n";
        print outFile "<th>\n<img src=\"./images/ormsg.png\">\n</th>\n</table><br><br>\n";

        print outFile "<menu>\n<h2>Index of OpenRM - lib", $i, " ";
        if ($info{$i}[1] > 0)
        {
            print outFile "Datatypes";
            if ($info{$i}[2] > 0)
            {
                 print outFile " and Functions</h2><br>\n";
            }
            else
            {
                 printf outFile "</h2><br>\n";
            }
        }
        else
        {
            if ($info{$i}[2] > 0)
            {
                 print outFile "Functions</h2><br>\n";
            }
        }

	# do datatypes if present 
        $lineCount = 0;
	if ($info{$i}[1] > 0)
	{
            print outFile "<h3>", uc($i), " Datatypes [", $info{$i}[1], "]</h3>\n";
	    for $j (0..$info{$i}[1])
	    {
		print outFile ${$i . "Data"}->[$j];
	        $lineCount++;
	        if (($lineCount > 9) && ($j < ($info{$i}[1] - 2))) # group output tags by 10 (no orphans!)
 	        {
		    $lineCount = 0;
		    print outFile "<br><br>\n";
	        }
 	    }
	}

	# do functions if present
        $lineCount = 0;
	if ($info{$i}[2] > 0)
	{
            print outFile "<h3>", uc($i), " Functions [", $info{$i}[2], "]</h3>\n";
	    for $j (0..$info{$i}[2])
	    {
		print outFile ${$i . "Func"}->[$j];
	        $lineCount++;
	        if (($lineCount > 9) && ($j < ($info{$i}[2] - 2))) # group output tags by 10 (no orphans!)
 	        {
		    $lineCount = 0;
		    print outFile "<br><br>\n";
	        }
 	    }
	}
        print outFile "</menu></body></html>\n";
        close outFile;
    }

    # output the master index file
    $tempFName = $ARGV[2] . "/" . $ARGV[1];
    open (outFile, ">$tempFName") or die "ERROR: cannot open the master index file.", $ARGV[1];

    # output header stuff
    print outFile "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n";
    print outFile "<html><head><title>OpenRM Scene Graph Libraries</title></head>\n";
    print outFile "<body bgcolor=white fgcolor=black> \n<table width=\"100%\" border=2 cellspacing=0 cellpadding=0 bgcolor=\"khaki\" valign=\"center\">\n";
    print outFile "<th>\n<img src=\"./images/ormsg.png\">\n</th>\n</table><br><br>\n";
    print outFile "<h2>OpenRM Scene Graph Libraries</h2><br><menu>\n";

    # generate library links
    for $i (sort keys %info)
    {
	@fields = split(/\s+/, $info{$i}[3]);
	print outFile "<li><a href=\"", $info{$i}[0], "\"> ", $fields[0], " </a>\n";
        $info{$i}[3] =~ /$fields[0] /;
        print outFile $', "\n</li><br><br>\n";
    }

    # done
    print outFile "</menu></body></html>\n";
    close outFile;
    exit;
}
# EOF
