/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rm.h,v 1.8 2005/06/12 21:21:46 wes Exp $
 *
 * $Revision: 1.8 $
 * Version: $Name: v180-alpha-02 $
 * $Log: rm.h,v $
 * Revision 1.8  2005/06/12 21:21:46  wes
 * Added <time.h> include.
 *
 * Revision 1.7  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.6  2005/01/23 17:17:02  wes
 * Copyright update to 2005.
 *
 * Revision 1.5  2004/01/17 04:05:41  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.4  2003/06/09 15:23:03  wes
 * Added conditional #define GLX_GLXEXT_PROTOTYPES to soothe problems when
 * using the Mesa glx.h with Chromium (thanks to Brian Paul for the suggestion).
 *
 * Revision 1.3  2003/02/02 17:50:55  wes
 * Added bounding boxes to RMprimitives, as a supplement to node-level bboxes.
 * The RMprimitive level bboxes are needed for the retained-mode CR work.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.1  2003/01/16 21:46:07  wes
 * Moved rm.h and rmaux.h into include/rm. Removed rm.h from include, and
 * removed rmaux/rmaux.h
 *
 * Revision 1.7  2002/12/31 00:57:03  wes
 *
 * Preliminary support for Chromium.
 *
 * Revision 1.6  2002/04/30 19:42:45  wes
 * Updated copyright dates.
 *
 * Revision 1.5  2001/03/31 17:13:57  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.4  2000/12/03 23:21:10  wes
 * *** empty log message ***
 *
 * Revision 1.3  2000/04/20 16:35:48  wes
 * Added EOF marker.
 *
 * Revision 1.2  2000/04/20 16:30:21  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rm_h_
#define _rm_h_

/*
 * NOTE: one of RM_X, RM_WIN or RM_CR must be defined on the compile line.
 * Use RM_X for use on X11 systems, RM_WIN for use on Windows systems,
 * or RM_CR for use on Chromium-enabled workstations (which may be
 * either Win32 or X11).
 */

#ifdef RM_WIN
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#ifdef RM_X
#ifndef GLX_GLXEXT_PROTOTYPES
#define GLX_GLXEXT_PROTOTYPES
#endif
#include <GL/glx.h>
#endif

#ifdef RM_CR
#include <chromium.h>
#endif

#include <math.h>
#include <time.h>

#ifdef RM_DLL_EXPORTS
#define RM_EXPORT_API _declspec(dllexport)
#define RM_EXPORT_VAR /* removed - globals not supported */
#else
#define RM_EXPORT_API
#define RM_EXPORT_VAR /* removed - globals not supported */
#endif

#include <rm/rmdefs.h>
#include <rm/rmtypes.h>

#ifdef RM_X
#include <rm/rmx.h>
#endif

#include <rm/rmvmap.h>

#ifdef RM_WIN
#include <rm/rmw.h>
#endif

#ifdef RM_CR
#include <rm/rmcr.h>
#endif

#include <rm/rmpipe.h>

#include <rm/rmpublic.h>

#include <rm/rmdeflts.h>

/* PS-specific includes */
#include <rm/rmps.h>

#endif /* _rm_h_ */
/* EOF */
