/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmaux.h,v 1.13 2008/11/23 15:03:53 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.13 $
 * $Name: v180-alpha-02 $
 * $Log: rmaux.h,v $
 * Revision 1.13  2008/11/23 15:03:53  wes
 * usrData pointers are void *, not const void *, in callback functions
 * so that applications may modify their own data
 *
 * Revision 1.12  2007/10/26 11:29:16  wes
 * Added a comment line containing a right brace to the end of each
 * typedef function prototype line. This addition needed to have the
 * document generator not die on this new typedefs
 *
 * Revision 1.11  2006/08/13 16:56:47  wes
 * Use typdefs for callback function prototypes.
 *
 * Revision 1.10  2006/08/08 03:49:05  wes
 * Ergonomic changes to rmaux callbacks.
 *
 * Revision 1.9  2006/08/07 12:49:55  wes
 * Added new parms to button and idle event callback: RMnode and void *usrData.
 *
 * Revision 1.8  2006/08/02 05:01:55  wes
 * Added RMnode * to parm list of app keyfunc callback routine.
 *
 * Revision 1.7  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.6  2005/01/23 17:17:02  wes
 * Copyright update to 2005.
 *
 * Revision 1.5  2004/01/17 04:05:41  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.4  2003/10/03 19:16:41  wes
 * Add rmauxSetSpinMode() and rmauxGetSpinMode() prototypes.
 *
 * Revision 1.3  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.2  2003/02/01 17:56:13  wes
 * Win32 code work to reflect new RMpipe initialization sequence.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.2  2003/01/27 05:04:27  wes
 * Changes to RMpipe API and initialization sequence to unify GLX, WGL and CR
 * platforms w/o too much disruption to existing apps.
 *
 * Revision 1.1  2003/01/16 21:46:07  wes
 * Moved rm.h and rmaux.h into include/rm. Removed rm.h from include, and
 * removed rmaux/rmaux.h
 *
 * Revision 1.11  2002/04/30 19:42:11  wes
 * Added a typedef for KeySym for Win32 to ensure API consistency between
 * key handler funcs in X11 and Win23. The KeySym typedef isn't used
 * for anything in Win32 except as an API compatibility enforcer.
 *
 * Revision 1.10  2001/10/15 00:16:50  wes
 * Added definitions for buttons 4 & 5. Changed definition for the idle
 * function - the return status of the idle function is now examined
 * in determining whether or not to exit the event loop.
 *
 * Revision 1.9  2001/07/15 17:22:28  wes
 * Added an RMnode * paramter to the proto for the app init function
 * set in rmauxSetInitFunc().
 *
 * Revision 1.8  2001/06/03 20:55:39  wes
 * Added key handler and resize callbacks.
 *
 * Revision 1.7  2001/03/31 18:46:16  wes
 * Added rmauxCreateOffscreenDrawable for Win32.
 *
 * Revision 1.6  2001/03/31 17:14:01  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.5  2000/12/03 23:21:21  wes
 * Mods for thread safety.
 *
 * Revision 1.4  2000/08/28 01:32:26  wes
 * Modified rmauxDolly and rmauxTranslate to use an input RMcamera3D
 * parameter, rather than making modifications directly to RMnode
 * scene parameters.
 *
 * Revision 1.3  2000/04/20 17:41:48  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:25  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

/*
 * MODIFICATIONS:
 *
 * modified header file for rmbfuncs.c and rmarcball.c changes
 * 08/16/2000 jdb
 *
 * modified user key and resize callbacks:
 *   folded into API (rmaux state)
 *   added default callback functions
 *   
 * added PGM/PPM I/O support (moved to $RM/rmi - wes)
 * 02/23/01 jdb
 *
 */

#ifndef _rmaux_h_
#define _rmaux_h_

#define RM_NUM_BUTTONS 5
#ifdef RM_X
#define RM_BUTTON1  Button1
#define RM_BUTTON2  Button2
#define RM_BUTTON3  Button3
#define RM_BUTTON4  Button4
#define RM_BUTTON5  Button5
#else
#define RM_BUTTON1  0x1
#define RM_BUTTON2  0x2
#define RM_BUTTON3  0x3
#define RM_BUTTON4  0x4
#define RM_BUTTON5  0x5
#define Button1     0x1
#define Button2     0x2
#define Button3     0x3
#define Button4     0x4
#define Button5     0x5

typedef int KeySym; /* to coerce X11 and Win32 compatibility for key handling*/
#endif

#define RM_NUM_BUTTON_MODIFIERS 3
#define RM_NONE_MODMASK    	0
#define RM_NO_MODIFIER      	0
#define RM_SHIFT_MODIFIER   	1
#define RM_CONTROL_MODIFIER 	2

#ifdef RM_X
#define RM_SHIFT_MODMASK   ShiftMask
#define RM_CONTROL_MODMASK ControlMask
#else
#define RM_SHIFT_MODMASK   1
#define RM_CONTROL_MODMASK 2
#endif

#define RMAUX_DEFAULT_SPIN_THRESHOLD 3.0F /* pixels */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * 8/2006. Introduced use of typedef's for callback functions to ease
 * integrating RMaux callback facilities with other languages (e.g., Python).
 * One lingering issue is the apparent disconnect between use of the
 * typedef declaration for a function prototype and actually instancing
 * a function of that particular type. In other words, you can use the
 * typedef for functions to enforce parameter lists in header files, but
 * you can't use that typedef if you want to actually write a function
 * of that type. Instead, you have to actually "spell out" the parm list
 * of your instance function.
 */
#define RMAUX_BUTTON_CALLBACK_FUNCTION_PARMS() (RMpipe *p, RMnode *n, void *usrData, int xbutton, int ybutton)

typedef int (*RMauxButtonCallbackFuncPrototype) (RMpipe *p, RMnode *n, void *usrData, int xbutton, int ybutton); /* } doc generator expects right brace on typedefs */
typedef int (*RMauxIdleCallbackFuncPrototype) (RMpipe *p, RMnode *n, void *usrData, int xbutton, int ybutton); /* } doc generator expects right brace on typedefs */
typedef int (*RMauxKeypressCallbackFuncPrototype) (RMpipe *p, RMnode *n, void *usrData, char key, KeySym code); /* } doc generator expects right brace on typedefs */
typedef void (*RMauxInitCallbackFuncPrototype) (RMpipe *p, RMnode *n, void *usrData); /* } doc generator expects right brace on typedefs */
typedef int (*RMauxRenderCallbackFuncPrototype) (RMpipe *p, RMnode *n, void *usrData); /* } doc generator expects right brace on typedefs */

/* rmbfuncs.c: general mouse and event loop [16-17] */
RM_EXPORT_API  void   rmauxEventLoop (RMpipe *drawToPipe, RMnode *subTreeToDraw, void *msg);
RM_EXPORT_API  void   rmauxSetGeomTransform (RMnode *target, RMpipe *pipe);

RM_EXPORT_API  void   rmauxSetSpinEnable (RMenum spinEnableBool);
RM_EXPORT_API  RMenum rmauxGetSpinEnable (void);

RM_EXPORT_API  void   rmauxSetCamera3DTransform (RMnode *target, RMpipe *pipe);
RM_EXPORT_API  void   rmauxUI (RMnode *target, RMpipe *pipe);
RM_EXPORT_API  void   rmauxSetInitCallbackFunc ( RMauxInitCallbackFuncPrototype,  void *usrData);
RM_EXPORT_API  void   rmauxSetIdleCallbackFunc ( RMauxIdleCallbackFuncPrototype, void *usrData);

RM_EXPORT_API  void   rmauxSetKeypressCallbackFunc ( RMauxKeypressCallbackFuncPrototype, void *usrData ); 
    
RM_EXPORT_API  void   rmauxSetRenderCallbackFunc ( RMauxRenderCallbackFuncPrototype, void *usrData);

RM_EXPORT_API  void   rmauxSetButtonDownCallbackFunc ( RMauxButtonCallbackFuncPrototype , void *usrData, unsigned int whichButtonNum, unsigned int modmask );
RM_EXPORT_API  void   rmauxSetButtonUpCallbackFunc ( RMauxButtonCallbackFuncPrototype , void *usrData ,unsigned int whichButtonNum, unsigned int modmask);
RM_EXPORT_API  void   rmauxSetButtonMotionCallbackFunc ( RMauxButtonCallbackFuncPrototype , void *usrData, unsigned int whichButton, unsigned int modmask );
    
RM_EXPORT_API  int    rmauxDefaultKeyFunc (RMpipe *currentPipe, RMnode *n, void *usrData, char key, KeySym code);

RM_EXPORT_API  void   rmauxSetResizeFunc (RMpipe *, RMnode *cameraNode, int (*userfunc) (RMpipe *currentPipe, RMnode *cameraNode, int pointerX, int pointerY));
RM_EXPORT_API  int    rmauxDefaultResizeFunc (RMpipe *currentPipe, RMnode *cameraNode, int pointerX, int pointerY);

#ifdef RM_WIN
RM_EXPORT_API  LONG WINAPI rmauxWndProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
#endif

/* rmcreatw.c: [2] */
#ifdef RM_WIN
RM_EXPORT_API  HWND rmauxCreateW32Window (RMpipe *useMe, HWND parent, int xpos,int ypos, int width, int height, char *wtitle, HINSTANCE hInstance, void *event_loop_fptr);
RM_EXPORT_API HWND rmauxCreateOffscreenDrawable (RMpipe *pipe, int width, int height, int depth, HINSTANCE hCurrentInst, void *eventLoopFuncPtr);
#endif
#ifdef RM_X
Window rmauxCreateXWindow (RMpipe *pipe, Window parent, int x, int y, int width, int height, const char *win_title, const char *icon_title, RMenum managed);
GLXPixmap rmauxCreateOffscreenDrawable (RMpipe *pipe, int width, int height, int depth);
#define RM_AUX_XWINDOW_EVENT_MASK    (ButtonPressMask | ButtonReleaseMask |  KeyPressMask | KeyReleaseMask | ExposureMask | VisibilityChangeMask | StructureNotifyMask | Button1MotionMask | Button2MotionMask | Button3MotionMask | ButtonMotionMask | PointerMotionMask | OwnerGrabButtonMask )
#endif

/* rmflyui.c: flight interface UI [4] */
RM_EXPORT_API  void rmauxFlyUI (RMnode *cameraNode, RMnode *drawNode, RMpipe *pipe, float orientationScale, float translateScale);
RM_EXPORT_API  int  rmauxFlyResetCamera RMAUX_BUTTON_CALLBACK_FUNCTION_PARMS();
RM_EXPORT_API  int  rmauxFlyToggleMotion RMAUX_BUTTON_CALLBACK_FUNCTION_PARMS();
RM_EXPORT_API  int  rmauxFlyMotionFunc RMAUX_BUTTON_CALLBACK_FUNCTION_PARMS();

/* rmarcball.c: ArcBall UI [3] */
RM_EXPORT_API  void rmauxArcBall (float *x1, float *y1, float *x2, float *y2, RMmatrix *result);
RM_EXPORT_API  void rmauxDolly (RMcamera3D *toModify, float *x1, float *y1, float *x2, float *y2);
RM_EXPORT_API  void rmauxTranslate (RMcamera3D *toModify, float *x1, float *y1, float *x2, float *y2);

#ifdef __cplusplus
}
#endif

#endif /* _rmaux_h_ */
/* EOF */
