/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmcr.h,v 1.8 2005/05/16 01:07:35 wes Exp $
 * $Revision: 1.8 $
 * Version: $Name: v180-alpha-02 $
 * $Log: rmcr.h,v $
 * Revision 1.8  2005/05/16 01:07:35  wes
 * Rename private_rmPipePostFBClearBarrier to private_rmPipePostFBClearBarrierCR.
 *
 * Revision 1.7  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.6  2005/01/23 17:17:02  wes
 * Copyright update to 2005.
 *
 * Revision 1.5  2004/01/17 04:05:41  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.4  2003/03/16 21:56:24  wes
 * Documentation updates.
 *
 * Revision 1.3  2003/02/18 15:40:37  wes
 * Added RMpipe wrapper functions for CR barrier creation and execution.
 *
 * Revision 1.2  2003/02/14 00:15:32  wes
 * Added CR-specific structure to the RMpipe, used to hold CR-specific things.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.4  2003/01/27 05:04:27  wes
 * Changes to RMpipe API and initialization sequence to unify GLX, WGL and CR
 * platforms w/o too much disruption to existing apps.
 *
 * Revision 1.3  2003/01/16 22:21:15  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.2  2003/01/14 05:28:53  wes
 * Added calls to CR extensions that enable shared display lists,
 * and texture object IDs.
 *
 * Revision 1.1  2002/12/31 00:50:40  wes
 * Initial entry.
 *
 */

#include <rm/rm.h>
#include <chromium.h>

#ifndef __rmcr_h
#define __rmcr_h

#define RM_CR_PRE_SWAPBUFFERS_BARRIER   0x0100
#define RM_CR_POST_SWAPBUFFERS_BARRIER  0x0101
#define RM_CR_POST_FBCLEAR_BARRIER      0x0102

#ifdef __cplusplus
extern "C" {
#endif
  
RM_EXPORT_API void   rmPipeInitCR(RMpipe **p, int rank, int globalNPE);
RM_EXPORT_API RMenum rmPipeSwapBuffersCR(const RMpipe *p);
RM_EXPORT_API RMenum rmPipeMakeCurrentCR(RMpipe *pipe);
RM_EXPORT_API RMenum rmPipeCreateContextCR(RMpipe *pipe);

RM_EXPORT_API RMenum rmPipeBarrierCreateCR (RMpipe *toModify, int barrierNumber);
RM_EXPORT_API RMenum rmPipeBarrierExecCR (RMpipe *toModify, int barrierNumber);

RM_EXPORT_API void  private_rmPipePostFBClearBarrierCR (const RMpipe *p);

#ifdef __cplusplus
}
#endif

#endif
