/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmdefs.h,v 1.15 2008/09/22 02:31:52 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.15 $
 * $Log: rmdefs.h,v $
 * Revision 1.15  2008/09/22 02:31:52  wes
 * New constants for scene graph synchronization
 *
 * Revision 1.14  2006/04/16 15:15:11  wes
 * Updated version to 1.6.2
 *
 * Revision 1.13  2005/06/15 02:10:29  wes
 * Added initial support for application-settable defaults. Apps
 * will use rmSetEnum/rmGetEnum to set or get defaults that are RMenums.
 * The first round of variables that can be set/get by apps are
 * RMnode traversal masks assigned to new scene graph nodes by rmNodeNew.
 *
 * Revision 1.12  2005/05/16 01:07:57  wes
 * Add RM_PIPE_NOPLATFORM definition
 *
 * Revision 1.11  2005/03/19 17:20:10  wes
 * PS code merge.
 *
 * Revision 1.10  2005/02/27 19:32:55  wes
 * Added support for application supplied texture object IDs and display lists.
 *
 * Revision 1.9  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.8  2005/01/23 17:17:34  wes
 * Copyright update to 2005.
 * Updates to support use of extensions: multitexturing on all platforms,
 * 3d texturing (for volume rendering support) on Win32
 *
 * Revision 1.7  2004/03/10 01:48:50  wes
 * Updated minor version to 1.5.2, added RM_INDEXED_QUAD_STRIP def.
 *
 * Revision 1.6  2004/02/23 03:04:29  wes
 * New primitives: RM_QUAD_STRIP, RM_INDEXED_TRIANGLES, RM_INDEXED_QUADS,
 * RM_INDEXED_TRIANGLE_STRIP.
 *
 * Revision 1.5  2004/01/17 04:05:41  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.4  2003/07/23 13:31:08  wes
 * Moved unistd.h include - it doesn't exist on windoze.
 *
 * Revision 1.3  2003/07/20 14:55:18  wes
 * Added unistd.h to avoid some compile warnings on Solaris.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.10  2003/01/27 05:04:27  wes
 * Changes to RMpipe API and initialization sequence to unify GLX, WGL and CR
 * platforms w/o too much disruption to existing apps.
 *
 * Revision 1.9  2003/01/16 22:21:15  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.8  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.7  2001/03/31 17:13:59  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.6  2000/12/03 23:20:22  wes
 * Thread-safety mods.
 *
 * Revision 1.5  2000/08/28 01:33:37  wes
 * Changed version number to RM_130.
 *
 * Revision 1.4  2000/05/17 14:30:36  wes
 * Added RM_POLYS (thanks to Matt and Todd from VRCO).
 *
 * Revision 1.3  2000/04/20 17:41:46  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:23  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmdefs_h
#define _rmdefs_h

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <limits.h>

#ifdef RM_X
#include <unistd.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#endif


/* RM version */
#define RM_VERSION_MAJOR 1
#define RM_VERSION_MINOR 6
#define RM_VERSION_REV   2

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
    /* booleans */
    RM_WHACKED          = -1,
    RM_FALSE            = 0,
    RM_TRUE             = 1,
    RM_CHILL            = 1,
    RM_MUTEX_UNLOCK     = 0,
    RM_MUTEX_LOCK       = 1,
    RM_MUTEX_BUSY       = 2,

    /* ragtag stuff */
    RM_NATIVE_OPENGL    = 0x010,
    RM_MESA_OPENGL      = 0x011,
    
    RM_HARDWARE         = 0x020,
    RM_SOFTWARE         = 0x021,

    RM_OR               = 0x030,
    RM_AND              = 0x031,
    RM_SET              = 0x032,

    /* ps enumerators */
    RM_PS_PORTRAIT      = 0x0100,
    RM_PS_LANDSCAPE     = 0x0101,

    RM_PS_REGULAR       = 0x0102,
    RM_PS_EPS           = 0x0103,

    RM_PS_VECTOR        = 0x0106,
    RM_PS_RASTER        = 0x0107,

    RM_PS_SORT_FAST              = 0x0110, /* centroid sort - fastest and least memory consumption, may produce rendering errors.  */
    RM_PS_SORT_BSP               = 0x0111, /* full scene BSP sort - slowest and largest memory consumption, no rendering issues. */
    RM_PS_SORT_FULL              = 0x0111, /* synonym with RM_PS_SORT_BSP */
    RM_PS_SORT_HYBRID_SCREEN_BSP = 0x0112, /* hybrid screen-space/object-space sort - has limitations, but is faster and requires less memory than SORT_FULL*/
    RM_PS_SORT_HYBRID_DEPTH_BSP  = 0x0113, /* depth-layering hybrid BSP subdivisions. Faster and less memory use than SORT_FULL but more than HYBRID_SCREEN, ought to not have same rendering limitations as HYBRID_SCREEN. Not yet implemented 9/11/04. */

    /* scene parms: these typically won't be accessed directly by the application */
    RM_SCENE_CAMERA3D              = 0x0121,
    RM_SCENE_VIEWPORT              = 0x0122,
    RM_SCENE_BACKGROUND_COLOR      = 0x0123,
    RM_SCENE_CAMERA2D              = 0x0124,
    RM_SCENE_BACKGROUND_IMAGE_TILE = 0x0125,

    RM_SCENE_CLIP_PLANE0 = 0x0126,
    RM_SCENE_CLIP_PLANE1 = 0x0127,
    RM_SCENE_CLIP_PLANE2 = 0x0128,
    RM_SCENE_CLIP_PLANE3 = 0x0129,
    RM_SCENE_CLIP_PLANE4 = 0x012A,
    RM_SCENE_CLIP_PLANE5 = 0x012B,

    RM_SCENE_INV_PROJECTION   = 0x012C, /* private */

    RM_SCENE_TEXTURE2D        = 0x012D,
    RM_SCENE_TEXTURE3D        = 0x012E,
    RM_SCENE_TEXTURE3D_UPDATE = 0x012F,

    /* 3D point & surface prims */
    RM_LINES               = 0x0140,
    RM_LINE_STRIP          = 0x0141,
    RM_TRIANGLES           = 0x0142,
    RM_TRIANGLE_STRIP      = 0x0143,
    RM_TRIANGLE_FAN        = 0x0144,
    RM_QUADMESH            = 0x0145,
    RM_POINTS              = 0x0146,
    RM_POLYS               = 0x0147,
    RM_QUAD_STRIP          = 0x0148,

    /* semi-procedural prims */
    RM_SPHERES             = 0x0150,
    RM_BOX3D               = 0x0151,
    RM_BOX3D_WIRE          = 0x0152,
    RM_CONES               = 0x0153,
    RM_CYLINDERS           = 0x0154,

    /* volume prims */
    RM_OCTMESH             = 0x0158,

    /* 2D-specific prims */
    RM_TEXT                = 0x0160,
    RM_INDEXED_TEXT        = 0x0161,
    RM_QUADS               = 0x0162, /* this one can be 2D or 3D */
    RM_MARKERS2D           = 0x0163,

    RM_CIRCLE2D            = 0x0164,
    RM_BOX2D               = 0x0165,
    RM_ELLIPSE2D           = 0x0166,

    RM_SPRITE              = 0x0167,
    RM_BITMAP              = 0x0168,
    RM_INDEXED_BITMAP      = 0x0169,

    /* indexed prims */
    RM_INDEXED_TFAN        = 0x0170,
    RM_INDEXED_QUADS       = 0x0171,
    RM_INDEXED_TRIANGLES   = 0x0172,
    RM_INDEXED_TRIANGLE_STRIP = 0x0173,
    RM_INDEXED_QUAD_STRIP  = 0x0174,

    /* prim that uses an app-defined display list */
    RM_APP_DISPLAYLIST     = 0x0175,


    RM_USERDEFINED_PRIM    = 0x0180,


    /* misc texture parameters */
    RM_TEXTURE_WRAP_CLAMP            = 0x0210,
    RM_TEXTURE_WRAP_REPEAT           = 0x0211,
    RM_TEXTURE_FILTER_NEAREST        = 0x0212,
    RM_TEXTURE_FILTER_LINEAR         = 0x0213,
    RM_TEXTURE_FILTER_MIPMAP_NEAREST = 0x0214,
    RM_TEXTURE_FILTER_MIPMAP_LINEAR  = 0x0215,

    /* rendering parms */
    RM_SHADER_SMOOTH  		= 0x0220,
    RM_SHADER_FLAT    		= 0x0221,
    RM_SHADER_NOLIGHT 		= 0x0222,

    /* polygon face defs and render modes, corresponds to glPolygonMode() */
    RM_FRONT            = 0x0230,
    RM_BACK             = 0x0231,
    RM_FRONT_AND_BACK   = 0x0232,
    RM_POINT            = 0x0233,
    RM_LINE             = 0x0234,
    RM_FILL             = 0x0235,
    
    /* face culling modes */
    RM_CULL_NONE            = 0x0240,
    RM_CULL_FRONT           = 0x0241,
    RM_CULL_BACK            = 0x0242,
    RM_CULL_FRONT_AND_BACK  = 0x0243,

    /* define face orientation for culling and lighting */
    RM_CCW              = 0x0250,
    RM_CW               = 0x0251,

    /* transformation enumerators */
    RM_TRANSFORM_GEOMETRY = 0x0260,
    RM_TRANSFORM_TEXTURE  = 0x0261,
    RM_TRANSFORM_IGNORE   = 0x0262,
    
    /* display format definitions */
    RM_ALL_CHANNELS           = 0x0270,
    RM_LEFT_CHANNEL           = 0x0271,
    RM_RIGHT_CHANNEL          = 0x0272,

    RM_MONO_CHANNEL           = 0x0273,
    RM_REDBLUE_STEREO_CHANNEL = 0x0274,
    RM_BLUERED_STEREO_CHANNEL = 0x0275,
    RM_MBUF_STEREO_CHANNEL    = 0x0276,
    
    RM_OFFSCREEN_MONO_CHANNEL      = 0x0277,
    RM_OFFSCREEN_REDBLUE_STEREO_CHANNEL = 0x0278,
    RM_OFFSCREEN_BLUERED_STEREO_CHANNEL = 0x0279,

    /* camera projection */
    RM_PROJECTION_ORTHOGRAPHIC = 0x0301,
    RM_PROJECTION_PERSPECTIVE  = 0x0302,

    /* light types */
    RM_LIGHT_POINT        = 0x0310,
    RM_LIGHT_DIRECTIONAL  = 0x0311,
    RM_LIGHT_SPOT         = 0x0312,

    RM_LIGHT0             = 0x0320,
    RM_LIGHT1             = 0x0321,
    RM_LIGHT2             = 0x0322,
    RM_LIGHT3             = 0x0323,
    RM_LIGHT4             = 0x0324,
    RM_LIGHT5             = 0x0325,
    RM_LIGHT6             = 0x0326,
    RM_LIGHT7             = 0x0327,

    /* image format enumerators */
    RM_IMAGE_ALPHA           = 0x0401,
#if 0
    RM_IMAGE_INDEXED_RGB     = 0x0402,
    RM_IMAGE_INDEXED_RGBA    = 0x0403,
#endif
    RM_IMAGE_LUMINANCE       = 0x0404,
    RM_IMAGE_LUMINANCE_ALPHA = 0x0405,
    RM_IMAGE_RGB             = 0x0406,
    RM_IMAGE_RGBA            = 0x0407,
    RM_IMAGE_DEPTH           = 0x0408,

    /* image type enums */
    RM_UNSIGNED_BYTE         = 0x0409,
    RM_FLOAT                 = 0x040A,
    RM_SHORT                 = 0x040B,
    RM_UNSIGNED_SHORT        = 0x040C,

    /* image mirroring enumerators */
    RM_IMAGE_MIRROR_WIDTH    = 0x0410,
    RM_IMAGE_MIRROR_HEIGHT   = 0x0411,
    RM_IMAGE_MIRROR_DEPTH    = 0x0412,

    /* data copy flags */
    RM_COPY_DATA         = 0x0420,
    RM_DONT_COPY_DATA    = 0x0421,
    RM_COPY_UNDEFINED    = 0x0422, /* an initial condition, used internally */

    /* line style enumerators */
    RM_LINES_SOLID         = 0x0501,
    RM_LINES_DASHED        = 0x0502,
    RM_LINES_DOTTED        = 0x0503,
    RM_LINES_DOT_DASH      = 0x0504,
    RM_LINES_DASH_DASH_DOT = 0x0505,

    /* line width enumerators */
    RM_LINEWIDTH_NARROW  = 0x0510,
    RM_LINEWIDTH_MEDIUM  = 0x0511,
    RM_LINEWIDTH_HEAVY   = 0x0512,

    RM_LINEWIDTH_1       = 0x0513,
    RM_LINEWIDTH_2       = 0x0514,
    RM_LINEWIDTH_3       = 0x0515,
    RM_LINEWIDTH_4       = 0x0516,
    RM_LINEWIDTH_5       = 0x0517,
    RM_LINEWIDTH_6       = 0x0518,
    RM_LINEWIDTH_7       = 0x0519,
    RM_LINEWIDTH_8       = 0x051A,
	
    /* text justification modes */
    RM_LEFT              = 0x0520,
    RM_CENTER            = 0x0521, /* used for either horiz or vert, or both */
    RM_RIGHT             = 0x0522,
    RM_TOP               = 0x0523,
    RM_BOTTOM            = 0x0524,

    RM_PRINT_TERSE       = 0x0520, /* for rmPrintSceneGraph */
    RM_PRINT_VERBOSE     = 0x0521,
	
    /* multi-pass tag definitions */
    RM_RENDERPASS_OPAQUE      = 0x0600,
    RM_RENDERPASS_TRANSPARENT = 0x0601,
    RM_RENDERPASS_3D          = 0x0602,
    RM_RENDERPASS_2D          = 0x0603,
    RM_RENDERPASS_ALL         = 0x0604,

    /* notification controls */
    RM_NOTIFY_SILENCE         = 0x0610,
    RM_NOTIFY_FULL            = 0x0611,

    /* multistage identification tokens */
    RM_VIEW                   = 0x0620,
    RM_RENDER                 = 0x0621,

    /* RMpipe processing mode tokens */
    RM_PIPE_SERIAL            = 0x0630,
    RM_PIPE_MULTISTAGE        = 0x0631,
    RM_PIPE_MULTISTAGE_PARALLEL = 0x0632,
    RM_PIPE_MULTISTAGE_VIEW_PARALLEL = 0x0633,
    /* the following NBLOCK modes are not yet implemented. */
    RM_PIPE_SERIAL_NOBLOCK    = 0x0634,
    RM_PIPE_MULTISTAGE_NOBLOCK = 0x0635,
    RM_PIPE_MULTISTAGE_PARALLEL_NOBLOCK = 0x0636,

    RM_PIPE_GLX               = 0x0650,
    RM_PIPE_WGL               = 0x0651,
    RM_PIPE_CR                = 0x0652,
    RM_PIPE_NOPLATFORM        = 0x0653,

    /* named default values that can be set/get by applications */
    RM_DEFAULT_NODE_PICK_TRAVERSAL_MASK    = 0x0700,
    RM_DEFAULT_NODE_TRAVERSAL_MASK         = 0x0701,

    /* data synchronization enums (Fall 2007) */
    RM_DATA_SYNC_NONE         = 0x0710,
    RM_DATA_SYNC_DRACONIAN    = 0x0711,
    RM_DATA_SYNC_DOUBLE_BUFFERED = 0x0712

} RMenum;

#ifdef __cplusplus
}
#endif


/* numerical constants */
#define RM_PI		3.1415926535897931
#define RM_TWO_PI	6.2831853071795862

#define	RM_SQRT2	1.4142135623730951
#define	RM_SQRT1_2	0.7071067811865476

#define RM_MAXFLOAT 	1.0e+20F
#define RM_MINFLOAT 	-1.0e+20F

/* constants and limits */
#define RM_MAX_STRING_LENGTH 		64

#define RM_SINGLEBUFFERED 		0
#define RM_DOUBLEBUFFERED 		1

#define RM_MAX_MIPMAPS   		16
#define RM_MAX_LIGHTS  			8
#define RM_MAX_MULTITEXTURES            8 /* 8 multitextures, 1 regular */

#define RM_FEEDBACK_MIN_BUFFER_SIZE	65536 /* for picking */

/* macros */
#define RM_MIN(a,b) 		 ((a) < (b) ? (a) : (b))
#define RM_MAX(a,b) 		 ((a) > (b) ? (a) : (b))

#define RM_DEGREES_TO_RADIANS(a) ((a)*0.017453292)
#define RM_RADIANS_TO_DEGREES(a) ((a) * 57.29577951)

/* font definitions
 *
 * Serif font -> Adobe Times
 * Sans Serif font -> Adobe Helvetica
 * Mono Font -> Adobe Courier
 * Symbol Font -> Adobe Symbol Roman
 *
 *
 * in an integer, we use the following bits for the following things:
 *
 * bit number   6     5      4     3       2    1    0
 *            font family   bold  italic   --size enum--
 *
 * the two bits of "font family" are used to create an index into a table
 * of font family names. there is one such table used in X and another
 * table used in Postscript.
 *
 * boolean values are used for "bold" and "italic". some font families,
 * like "symbol", don't support these faces.
 *
 * three bits are used for sizing information. again, these are indices
 * into a table of ints which are real live point sizes.  this table should
 * eventually be built at run time from the list of available fonts
 * on the server.  for now, it's hard coded.
 */

#define RM_NUM_FONT_FACES	5

#define RM_FONT_SERIF		0
#define RM_FONT_SANS		1
#define RM_FONT_MONO		2
#define RM_FONT_SYMBOL		3
#define RM_FONT_DINGBATS	4

#define RM_NUM_FONT_SIZES	7

#define RM_FONT_XXS		0
#define RM_FONT_XS		1
#define RM_FONT_S		2
#define RM_FONT_M		3
#define RM_FONT_L		4
#define RM_FONT_XL		5
#define RM_FONT_XXL		6

/* plain + bold + italic + bold&italic */
#define RM_NUM_FONT_STYLES	4

/* stuff for line styles */
#define RM_MAX_LINESTYLES	5
#define RM_MAX_LINEWEIGHTS	8

/*
 * definitions for predefined procedural models. these include
 * model selection flags for spheres, cones and cylinders.
 *
 * use a particular model flag enumerator with
 * rmPrimitiveSetModelFlag() to control which of the prebuilt
 * models is used when your primitive is rendered. the goal is
 * to provide applications a mechanism to select from one of
 * several different resolution models.
 *
 * Note to RMSG developers: changes to any of these groups will
 * necessitate corresponding changes in $RMSG/rm/rmqdrix.c. 
 */

/*
 * sphere model flags
 */
#define RM_SPHERES_8     1	/* an octahedron */
#define RM_SPHERES_32    2	/* 32 faces - this is the default  */
#define RM_SPHERES_128   3	/* 128 faces */
#define RM_SPHERES_512   4	/* 512 faces */

/*
 * cones - some definitions for cones of varying resolutions. these
 * values indicate the number of subdivisions along the radial axis
 * of the cone.
 */
#define RM_CONES_4	4	/* 4-sided cone */
#define RM_CONES_8	8	/* 8 sides */
#define RM_CONES_12	12	/* etc. */
#define RM_CONES_16	16	/* 16 sides (the default) */
#define RM_CONES_32	32	
#define RM_CONES_64	64	
#define RM_CONES_128	128

/*
 * cylinders - same as cones.
 */
#define RM_CYLINDERS_4		4	/* 4-sided cylinder */
#define RM_CYLINDERS_8		8	/* etc. */
#define RM_CYLINDERS_12		12
#define RM_CYLINDERS_16		16 /* 16 sides (the default) */
#define RM_CYLINDERS_32		32
#define RM_CYLINDERS_64		64
#define RM_CYLINDERS_128	128

/*
 * octmesh model flags. these are "divide by" constants. when the
 * octmesh is rendered, RM figures out how many slices of volume
 * should be rendered as a function of maximum grid resolution.
 * then, this value is reduced through division by one of these
 * constants. the tradeoff is speed vs. resolution.
 */
#define RM_OCTMESH_1	0x0001	/* (the default) */
#define RM_OCTMESH_2	0x0002
#define RM_OCTMESH_4	0x0004
#define RM_OCTMESH_8	0x0008
#define RM_OCTMESH_16	0x0010

#define RM_OCTMESH_DIVISOR_MASK 0x001F

/* use 2d textures for rendering octmeshes */
#define RM_OCTMESH_2DTEXTURES_MIN_MEMORY              0x0040
#define RM_OCTMESH_2DTEXTURES_MAX_PERFORMANCE         0x0080
/* #define RM_OCTMESH_2DTEXTURES_IBRAVR       0x0100 */ /* 1/17/05, to do later */
#endif /* _rmdefs_h */
/* EOF */
