/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmi.h,v 1.5 2005/02/19 16:47:24 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.5 $
 * $Name: v180-alpha-02 $
 * $Log: rmi.h,v $
 * Revision 1.5  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.4  2005/01/23 17:17:02  wes
 * Copyright update to 2005.
 *
 * Revision 1.3  2004/01/17 04:05:41  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.2  2003/01/16 22:21:15  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.1  2003/01/16 21:54:45  wes
 * Moved header files from include/rmi to their new home in include/rm.
 *
 * Revision 1.2  2002/04/30 19:41:06  wes
 * Updated copyright dates.
 *
 * Revision 1.1  2001/06/03 20:54:19  wes
 * Initial entry.
 *
 */

#ifndef __rmi_h
#define __rmi_h

/*
 * This file contains includes and defines that provide support for
 * image loaders and writers. Each format has a separate .h and
 * source base. Some formats (e.g., PPM) are supported by
 * standalone code inside RM; other formats (e.g., JPEG) require
 * both 3rd party libraries as well as some reader code that
 * is part of RM.
 *
 * You can choose to selectively enable or disable support for
 * those libraries that require 3rd party libraries. Swim through
 * this file and look for #define's. If the #define is set to
 * 1 (one), then the code is compiled in that calls the 3rd party
 * library. On the other hand, if the #define is set to 0 (zero),
 * no calls are made to the 3rd party library (no headers are
 * included, either) so that you can at least compile the RMI
 * code, but you won't have image loader support for that format, either.
 */


/* PPM has built-in support, no need for a 3rd party library */
#include <rm/rmppm.h>

/* JPEG requires libjpeg.a and some jpeg headers. Not all vendors
 include this stuff with their machines. You can obtain source for
 JPEG from www.ijg.org. */
#define RM_JPEG 1	/* change the 1 to a zero if you don't
			   want OpenRM to be compiled with JPEG support */
#include <rm/rmjpeg.h>

#endif

/* EOF */
