/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmps.h,v 1.1 2005/04/29 16:57:32 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.1 $
 * $Log: rmps.h,v $
 * Revision 1.1  2005/04/29 16:57:32  wes
 * Initial entry - code merge.
 *
 */

#ifndef __rmps_h
#define __rmps_h

#ifdef __cplusplus
extern "C" {
#endif
    
/*
 * Control structure for generating PS files.
 */
typedef struct
{
    int psWidthPoints;		/* width, height in pts of PS canvas */
    int psHeightPoints;
    int psMinMargin;		/* minimum page marin in points */
    RMenum psOrientation;	/* RM_PS_PORTRAIT or RM_PS_LANDSCAPE */

    RMenum psRasterOrVector;	/* RM_PS_VECTOR or RM_PS_RASTER */
    RMenum psOutputFormat; 	/* RM_PS_REGULAR or RM_PS_EPS */
    RMenum psSortMethod;

    char *fName;

    /* private variables */
    FILE *fHandle;
    
} RMpsSpec;

RM_EXPORT_API RMenum    rmFramePS (RMpipe *drawOn, RMnode *subTree, RMpsSpec *controlStruct);
RM_EXPORT_API RMenum    rmFramePSHeartbeat(RMpipe *drawOn, RMnode *subTree, RMpsSpec *p, int (*heartBeatFunc)(int percentComplete));

RM_EXPORT_API RMpsSpec *rmPSSpecNew(void);
RM_EXPORT_API RMenum    rmPSSpecDelete(RMpsSpec *toDelete);

RM_EXPORT_API RMenum rmPSPageSetSize(RMpsSpec *p, int pagePointsWidth, int pagePointsHeight);
RM_EXPORT_API RMenum rmPSPageGetSize(const RMpsSpec *p, int *pagePointsWidth, int *pagePointsHeight);

RM_EXPORT_API RMenum rmPSPageSetOrientation(RMpsSpec *p, RMenum orientation);
RM_EXPORT_API RMenum rmPSPageGetOrientation(const RMpsSpec *p);

RM_EXPORT_API RMenum rmPSPageSetOutputFormat(RMpsSpec *p, RMenum outputFormat);
RM_EXPORT_API RMenum rmPSPageGetOutputFormat(const RMpsSpec *p);

RM_EXPORT_API RMenum rmPSPageSetVectorFormat(RMpsSpec *p, RMenum trueOrFalse);
RM_EXPORT_API RMenum rmPSPageGetVectorFormat(const RMpsSpec *p);

RM_EXPORT_API RMenum rmPSPageSetMargin(RMpsSpec *p, int minMarginPoints);
RM_EXPORT_API RMenum rmPSPageGetMargin(const RMpsSpec *p, int *minMarginPointsReturn);
    
RM_EXPORT_API RMenum rmPSSetOutputFilename(RMpsSpec *p, const char *fName);
RM_EXPORT_API const char * rmPSGetOutputFilename(const RMpsSpec *p);

RM_EXPORT_API RMenum rmPSSetSortMethod(RMpsSpec *p, RMenum sortMethod);
RM_EXPORT_API RMenum rmPSGetSortMethod(const RMpsSpec *p);

#ifdef __cplusplus
}
#endif

#endif
/* EOF */
