/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */

/*
 * $Id: rmpublic.h,v 1.28 2008/11/23 15:05:28 wes Exp $
 *
 * $Revision: 1.28 $
 * Version: $Name: v180-alpha-02 $
 * $Log: rmpublic.h,v $
 * Revision 1.28  2008/11/23 15:05:28  wes
 * 1. size_t parm for rmVertex*New, rmColor*New.
 * 2. Add rmArrayRemove() function prototype
 * 3. Add rmNodeRemoveIthChild
 *
 * Revision 1.27  2008/09/22 02:32:23  wes
 * New scene graph synchronization routines
 *
 * Revision 1.26  2007/04/22 15:18:06  wes
 * 1. Removed deprecated routine definition rmSwapBuffers.
 * 2. For all RMarray functions that have a size parameter, change it
 * from an int to a size_t
 *
 * Revision 1.25  2006/11/19 17:17:30  wes
 * rmSubtreeDelete API change: new second RMenum/bool argument
 *
 * Revision 1.24  2006/08/07 12:50:15  wes
 * Added rmArraySet
 *
 * Revision 1.23  2006/07/14 21:02:49  wes
 * Update rmPrimitiveSet* routines to use a size_t rather than int parm
 * for the count of number of things being set. This change will allow
 * >2G things to be set in a single blob (you better hope you have
 * enough memory on your machine for this action!!).
 *
 * Revision 1.22  2005/06/15 02:10:29  wes
 * Added initial support for application-settable defaults. Apps
 * will use rmSetEnum/rmGetEnum to set or get defaults that are RMenums.
 * The first round of variables that can be set/get by apps are
 * RMnode traversal masks assigned to new scene graph nodes by rmNodeNew.
 *
 * Revision 1.21  2005/06/12 21:22:56  wes
 * Minor documentation changes.
 *
 * Revision 1.20  2005/05/28 16:26:34  wes
 * Added pickEnable attribute to RMnodes, and function prototypes for
 * rmNodeSetPickEnable and rmNodeGetPickEnable
 *
 * Revision 1.19  2005/05/16 01:08:33  wes
 * Removed dead code.
 *
 * Revision 1.18  2005/03/19 17:19:48  wes
 * Fixed typo on rmMarkerInternal2DDelete function prototype.
 *
 * Revision 1.17  2005/02/27 19:32:55  wes
 * Added support for application supplied texture object IDs and display lists.
 *
 * Revision 1.16  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.15  2005/01/23 17:17:34  wes
 * Copyright update to 2005.
 * Updates to support use of extensions: multitexturing on all platforms,
 * 3d texturing (for volume rendering support) on Win32
 *
 * Revision 1.14  2004/04/09 14:47:31  wes
 * No significant changes.
 *
 * Revision 1.13  2004/03/30 14:13:05  wes
 * Fixed declarations for a couple of routines.
 *
 * Revision 1.12  2004/03/10 01:48:50  wes
 * Updated minor version to 1.5.2, added RM_INDEXED_QUAD_STRIP def.
 *
 * Revision 1.11  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.10  2003/12/06 03:26:04  wes
 * Documentation tweaks to RMtime routines, updates to RMtime routines for
 * Windows.
 *
 * Revision 1.9  2003/12/01 02:13:37  wes
 * Additions to support constate-rate rendering on Unix and Win32.
 *
 * Revision 1.8  2003/11/22 00:53:52  wes
 * Changes to support RMtextures being shared when assigned as scene parameters
 * to properly implement instancing.
 *
 * Revision 1.7  2003/11/16 16:18:32  wes
 * Added routine rmTimeSleep.
 *
 * Revision 1.6  2003/11/05 15:36:32  wes
 * Added rmTime* family of routines to measure time.
 *
 * Revision 1.5  2003/06/20 01:40:56  wes
 * Marked rmNodeSet/GetOpacity as being deprecated. These routines will be
 * removed in v1.5.1.
 *
 * Revision 1.4  2003/04/05 14:14:40  wes
 * Renamed rmMutexDestroy to rmMutexDelete.
 *
 * Revision 1.3  2003/02/02 17:50:55  wes
 * Added bounding boxes to RMprimitives, as a supplement to node-level bboxes.
 * The RMprimitive level bboxes are needed for the retained-mode CR work.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.15  2002/09/17 14:12:54  wes
 * Added rmComponentManagerPrintStatus() - v1.4.3
 *
 * Revision 1.14  2002/08/19 00:54:26  wes
 * Added API entries for new experiemental routines to get and set
 * the size of the OpenRM component manager object pool.
 *
 * Revision 1.13  2002/08/19 00:29:34  wes
 * Created external declarations for the rmStats* family of routines.
 *
 * Revision 1.12  2002/08/17 15:18:25  wes
 * Added two new routines: rmNodeSetRenderOrderCallback() and
 * rmInitComponentPoolSize().
 *
 * Revision 1.11  2002/06/17 01:11:06  wes
 * Removed rmPickListDelete, rmSubtreeFrame and a couple of other
 * routines that were not actually defined anywhere in the code.
 * Added rmPickDelete definition.
 *
 * Revision 1.10  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.9  2001/07/15 17:21:47  wes
 * Cleaned up prototype for rmTextPropsSetAttribs().
 *
 * Revision 1.8  2001/03/31 17:13:59  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.7  2000/12/05 03:13:11  wes
 * Removed unused code, added rmFrame() [!].
 *
 * Revision 1.6  2000/12/03 23:20:22  wes
 * Thread-safety mods.
 *
 * Revision 1.5  2000/10/03 11:41:14  wes
 * Contribution from jdb - proto cleanups.
 *
 * Revision 1.4  2000/05/17 14:31:00  wes
 * Fixed compile warnings on rmTextPropsSet/GetAttribs().
 *
 * Revision 1.3  2000/05/14 23:35:31  wes
 * Minor updates to reflect doc changes.
 *
 * Revision 1.2  2000/04/20 16:30:23  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmpublic_h
#define _rmpublic_h

/* macros */
#define VCOPY(s,d)  	memcpy((void *)(d),(void *)(s),sizeof(RMvertex3D))
#define V3COPY(s,d) 	memcpy((void *)(d),(void *)(s),sizeof(RMvertex3D))
#define V2COPY(s,d) 	memcpy(d,s,sizeof(RMvertex2D))
#define V4COPY(s,d) 	memcpy(d,s,sizeof(RMcolor4D))

#ifdef __cplusplus
extern "C" {
#endif

/* rmarray.c: array routines [8] */
RM_EXPORT_API  RMenum       rmArrayAdd(RMarray *toModify, const void *newData);
RM_EXPORT_API  RMenum       rmArrayDelete(RMarray **a);
RM_EXPORT_API  void        *rmArrayGet(const RMarray *toQuery, size_t indx);
RM_EXPORT_API  RMarray     *rmArrayNew(size_t initSize, size_t chunkSize, size_t elementSize);
RM_EXPORT_API  size_t       rmArrayNumItems(const RMarray *toQuery);
RM_EXPORT_API  RMenum       rmArraySet(RMarray *toModify, size_t indx, const void *newData);
RM_EXPORT_API  RMenum       rmArrayRemove(RMarray *toModify, size_t indx);
RM_EXPORT_API  void         rmArraySort(RMarray *, int (*compareFunc)(const void *a, const void *b));

/* rmbitmap.c: bitmap routines [8] */
RM_EXPORT_API  RMbitmap    *rmBitmapNew (int width, int height);
RM_EXPORT_API  RMenum       rmBitmapCopy (RMbitmap *dst, const RMbitmap *src);
RM_EXPORT_API  RMbitmap    *rmBitmapDup (const RMbitmap *src);
RM_EXPORT_API  void         rmBitmapDelete (RMbitmap *toDelete);
RM_EXPORT_API  RMenum       rmBitmapSetPixelData (RMbitmap *toModify, const void *pixeldata);
RM_EXPORT_API  void        *rmBitmapGetPixelData (const RMbitmap *toQuery);
RM_EXPORT_API  RMenum       rmBitmapGetSize (const RMbitmap *toQuery, int *widthReturn, int *heightReturn, int *bytesWidthReturn);
RM_EXPORT_API  RMenum       rmBitmapSetBit (RMbitmap *toModify, int columnIndex, int rowIndex);

/* rmcamera.c: 2D cameras [11] */
RM_EXPORT_API  RMcamera2D  *rmCamera2DNew (void);
RM_EXPORT_API  RMenum       rmCamera2DCopy (RMcamera2D *dst, const RMcamera2D *src);
RM_EXPORT_API  void         rmCamera2DDelete (RMcamera2D *toDelete);
RM_EXPORT_API  RMenum       rmDefaultCamera2D (RMcamera2D *c);
RM_EXPORT_API  RMenum       rmCamera2DSetAspectRatio (RMcamera2D *toModify, float newAspect);
RM_EXPORT_API  RMenum       rmCamera2DResetAspectRatio (RMcamera2D *toModify, const float *vp, int windowWidth, int windowWeight);
RM_EXPORT_API  RMenum       rmCamera2DGetAspectRatio (const RMcamera2D *toQuery, float *retValue);
RM_EXPORT_API  RMenum       rmCamera2DSetExtents (RMcamera2D *toModify, float xmin, float ymin, float xmax, float ymax);
RM_EXPORT_API  RMenum       rmCamera2DGetExtents (const RMcamera2D *toQuery, float *xmin, float *ymin, float *xmax, float *ymax);
RM_EXPORT_API  RMenum       rmCamera2DComputeViewMatrix (const RMcamera2D *c, RMmatrix *m);
RM_EXPORT_API  RMenum       rmCamera2DComputeViewFromGeometry (RMcamera2D *toModify, const RMnode *source);

/* rmcamera.c: 3D cameras [29] */
RM_EXPORT_API  RMcamera3D  *rmCamera3DNew (void);
RM_EXPORT_API  RMenum       rmCamera3DCopy (RMcamera3D *dst, const RMcamera3D *src);
RM_EXPORT_API  void         rmCamera3DDelete (RMcamera3D *toDelete);
RM_EXPORT_API  RMenum       rmDefaultCamera3D (RMcamera3D *c);
RM_EXPORT_API  RMenum       rmCamera3DSetAspectRatio (RMcamera3D *toModify, const float newAspect);
RM_EXPORT_API  RMenum       rmCamera3DResetAspectRatio (RMcamera3D *toModify, const float *vp, int windowWidth, int windowHeight);
RM_EXPORT_API  float        rmCamera3DGetAspectRatio (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DSetProjection (RMcamera3D *toQuery, RMenum newVal);
RM_EXPORT_API  RMenum       rmCamera3DGetProjection (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DSetEye (RMcamera3D *toModify, const RMvertex3D *newEye);
RM_EXPORT_API  RMenum       rmCamera3DGetEye (const RMcamera3D *toQuery, RMvertex3D *returnEye);
RM_EXPORT_API  RMenum       rmCamera3DSetAt (RMcamera3D *toModify, const RMvertex3D *newAt);
RM_EXPORT_API  RMenum       rmCamera3DGetAt (const RMcamera3D *toQuery, RMvertex3D *returnAt);
RM_EXPORT_API  RMenum       rmCamera3DSetUpVector (RMcamera3D *toModify, const RMvertex3D *newUpVector);
RM_EXPORT_API  RMenum       rmCamera3DGetUpVector (const RMcamera3D *toQuery, RMvertex3D *returnUpVector);
RM_EXPORT_API  RMenum       rmCamera3DSetFOV (RMcamera3D *toQuery, float newFOV);
RM_EXPORT_API  float        rmCamera3DGetFOV (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DSetHither (RMcamera3D *toModify, float newHither);
RM_EXPORT_API  float        rmCamera3DGetHither (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DSetYon (RMcamera3D *toModify, float newYon);
RM_EXPORT_API  float        rmCamera3DGetYon (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DSetStereo (RMcamera3D *toModify, RMenum newBoolValue);
RM_EXPORT_API  RMenum       rmCamera3DGetStereo (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DSetEyeSeparation (RMcamera3D *toModify, float newval);
RM_EXPORT_API  float        rmCamera3DGetEyeSeparation (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DSetFocalDistance (RMcamera3D *toModify, float newval);
RM_EXPORT_API  float        rmCamera3DGetFocalDistance (const RMcamera3D *toQuery);
RM_EXPORT_API  RMenum       rmCamera3DComputeViewMatrix (const RMcamera3D *source, RMmatrix *viewReturn, RMmatrix *projectionReturn);
RM_EXPORT_API  RMenum       rmCamera3DComputeViewFromGeometry (RMcamera3D *toModify, const RMnode *source, int windowWidth, int windowHeight);

/* rmclip.c: clipping plane routines [7] */
RM_EXPORT_API  RMclipPlane *rmClipPlaneNew (void);
RM_EXPORT_API  RMenum       rmClipPlaneDelete (RMclipPlane *toDelete);
RM_EXPORT_API  RMenum       rmClipPlaneSetPointNormal (RMclipPlane *toModify, const RMvertex3D *point, const RMvertex3D *normal);
RM_EXPORT_API  RMenum       rmClipPlaneGetPointNormal (const RMclipPlane *toQuery, RMvertex3D *point, RMvertex3D *normal);
RM_EXPORT_API  RMenum       rmClipPlaneEnable (RMclipPlane *toModify);
RM_EXPORT_API  RMenum       rmClipPlaneDisable (RMclipPlane *toModify);
RM_EXPORT_API  RMenum       rmClipPlaneIsEnabled (const RMclipPlane *toQuery);

/* rmcmpmgr.c: the RM component manager [1] */
RM_EXPORT_API  void         rmComponentManagerPrintStatus(void);

/* rmerror.c: errors, warnings and notices [4] */
RM_EXPORT_API  void         rmError (const char *msg);
RM_EXPORT_API  void         rmNotice (const char *msg);
RM_EXPORT_API  RMenum       rmNotifyLevel (RMenum level);
RM_EXPORT_API  void         rmSplash (const char *msg);  
RM_EXPORT_API  void         rmWarning (const char *msg);

/* rmdefaults.c: set/get routines for default values [2] */
RM_EXPORT_API  RMenum       rmGetEnum(RMenum queryTag, RMenum *returnValue);
RM_EXPORT_API  RMenum       rmSetEnum(RMenum setTag, RMenum newValue);

/* rmfog.c: fogging routines [11] */
RM_EXPORT_API  RMfog       *rmFogNew (void);
RM_EXPORT_API  RMfog       *rmFogDup (const RMfog *toDuplicate);
RM_EXPORT_API  RMenum       rmFogDelete (RMfog *toDelete);
RM_EXPORT_API  RMenum       rmFogSetMode (RMfog *toModify, GLenum newMode);
RM_EXPORT_API  GLenum       rmFogGetMode (const RMfog *toQuery);
RM_EXPORT_API  RMenum       rmFogSetColor (RMfog *toModify, const RMcolor4D *newColor);
RM_EXPORT_API  RMenum       rmFogGetColor (const RMfog *toQuery, RMcolor4D *returnColor);
RM_EXPORT_API  RMenum       rmFogSetDensity (RMfog *toModify, GLfloat newDensity);
RM_EXPORT_API  GLfloat      rmFogGetDensity (const RMfog *toQuery);
RM_EXPORT_API  RMenum       rmFogSetStartEnd (RMfog *toModify, GLfloat newStart, GLfloat newEnd);
RM_EXPORT_API  RMenum       rmFogGetStartEnd (const RMfog *toModify, GLfloat *startReturn, GLfloat *endReturn);

/* rmframe.c: rendering functions [2] */
RM_EXPORT_API  void rmFrame (RMpipe *drawToPipe, RMnode *rootedTree);
RM_EXPORT_API  void rmFrameDataSync (RMpipe *drawToPipe, RMnode *rootedTree);

/* rmimage.c: image routines [20] */
RM_EXPORT_API  RMimage     *rmImageNew (int ndims, int width, int height, int depth, RMenum formatEnum, RMenum typeEnum, RMenum copyFlag);
RM_EXPORT_API  RMimage     *rmImageDup (const RMimage *toDuplicate);
RM_EXPORT_API  RMenum       rmImageDelete (RMimage *toDelete);
RM_EXPORT_API  RMenum       rmImageSetPixelData (RMimage *toModify, void *pixelData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  void        *rmImageGetPixelData (const RMimage *toQuery);
RM_EXPORT_API  unsigned int rmImageGetBytesPerScanline (const RMimage *toQuery);
RM_EXPORT_API  RMenum       rmImageGetCopyFlag (const RMimage *toQuery);
RM_EXPORT_API  RMenum       rmImageGetType (const RMimage *toQuery);
RM_EXPORT_API  RMenum       rmImageGetFormat (const RMimage *toQuery);
RM_EXPORT_API  RMenum       rmImageGetImageSize (const RMimage *toQuery, int *returnNDims, int *returnWidth, int *returnHeight, int *returnDepth, int *returnElements, int *returnBytesPerScanline);
RM_EXPORT_API  RMenum       rmImageSetPixelZoom (RMimage *toModify, float xzoom, float yzoom);
RM_EXPORT_API  RMenum       rmImageGetPixelZoom (const RMimage *toQuery, float *returnXZoom, float *returnYZoom);
RM_EXPORT_API  RMenum       rmImageSetVismap (RMimage *toModify, const RMvisMap *vismap);
RM_EXPORT_API  RMenum       rmImageGetVismap (const RMimage *toQuery, RMvisMap **vismapReturn);
RM_EXPORT_API  RMenum       rmImageMirror (RMimage *toMirror, RMenum mirrorAxisEnum);
RM_EXPORT_API  RMenum       rmImageResize (const RMimage *src, RMimage *dst, RMenum hardwareEnum, RMpipe *p);
RM_EXPORT_API  RMenum       rmImageSetScale (RMimage *toModify, float newScale);
RM_EXPORT_API  RMenum       rmImageGetScale (const RMimage *toQuery, float *returnScale);
RM_EXPORT_API  RMenum       rmImageSetBias (RMimage *toModify, float newBias);
RM_EXPORT_API  RMenum       rmImageGetBias (const RMimage *toQuery, float *returnBias);

/* rmlites.c: light sources [18] */
RM_EXPORT_API  RMlight     *rmLightNew (void);
RM_EXPORT_API  void         rmLightDelete (RMlight *toDelete);
RM_EXPORT_API  RMenum       rmLightSetType (RMlight *toModify, RMenum newType);
RM_EXPORT_API  RMenum       rmLightGetType (const RMlight *toQuery);
RM_EXPORT_API  RMenum       rmLightSetXYZ (RMlight *toModify, const RMvertex3D *newXYZ);
RM_EXPORT_API  RMenum       rmLightGetXYZ (const RMlight *toQuery, RMvertex3D *retXYZ);
RM_EXPORT_API  RMenum       rmLightSetColor (RMlight *toModify, const RMcolor4D *newAmbientColor, const RMcolor4D *newDiffuseColor, const RMcolor4D *newSpecularColor);
RM_EXPORT_API  RMenum       rmLightGetColor (const RMlight *toQuery, RMcolor4D *retAmbientColor, RMcolor4D *retDiffuseColor, RMcolor4D *retSpecularColor);
RM_EXPORT_API  RMenum       rmLightSetAttenuation (RMlight *toModify, float newConstantAttenuation, float newLinearAttenuation, float newQuadraticAttenuation);
RM_EXPORT_API  RMenum       rmLightGetAttenuation (const RMlight *toQuery, float *retConstantAttenuation, float *retLinearAttenuation, float *retQuadraticAttenuation);
RM_EXPORT_API  RMenum       rmLightSetEnable (RMlight *toModify, RMenum newValue);
RM_EXPORT_API  RMenum       rmLightGetEnable (const RMlight *toQuery);
RM_EXPORT_API  RMenum       rmLightSetSpotDirection (RMlight *toModify, const RMvertex3D *newSpotDirection);
RM_EXPORT_API  RMenum       rmLightGetSpotDirection (const RMlight *toModify, RMvertex3D *retDirection);
RM_EXPORT_API  RMenum       rmLightSetSpotCutoff (RMlight *toModify, float newValue);
RM_EXPORT_API  RMenum       rmLightGetSpotCutoff (const RMlight *toQuery, float *retValue);
RM_EXPORT_API  RMenum       rmLightSetSpotExponent (RMlight *toModify, float newValue);
RM_EXPORT_API  RMenum       rmLightGetSpotExponent (const RMlight *toQuery, float *retValue);

/* rmlites.c: light models [9] */
RM_EXPORT_API RMlightModel *rmLightModelNew (void);
RM_EXPORT_API  RMenum       rmLightModelDelete (RMlightModel *toDelete);
RM_EXPORT_API  RMenum       rmLightModelSetAmbient (RMlightModel *toModify, const RMcolor4D *newAmbientColor);
RM_EXPORT_API  RMenum       rmLightModelGetAmbient (const RMlightModel *toQuery, RMcolor4D *retAmbientColor);
RM_EXPORT_API  RMenum       rmLightModelSetTwoSided (RMlightModel *toModify, RMenum newValue);
RM_EXPORT_API  RMenum       rmLightModelGetTwoSided (const RMlightModel *toQuery);
RM_EXPORT_API  RMenum       rmLightModelSetLocalViewer (RMlightModel *toModify, RMenum newValue);
RM_EXPORT_API  RMenum       rmLightModelGetLocalViewer (const RMlightModel *toQuery);
RM_EXPORT_API  RMenum       rmDefaultLighting (RMnode *toModify);

/* rmmalloc.c: creation and deletion functions [25] */
RM_EXPORT_API  float       *rmFloatNew (int num_floats);
RM_EXPORT_API  void         rmFloatDelete (float *f);
RM_EXPORT_API  RMvertex2D  *rmVertex2DNew (size_t n);
RM_EXPORT_API  void         rmVertex2DDelete (RMvertex2D *);
RM_EXPORT_API  RMvertex3D  *rmVertex3DNew (size_t n);
RM_EXPORT_API  void         rmVertex3DDelete (RMvertex3D *);
#define                     rmColor3DNew(a) ((RMcolor3D *)rmVertex3DNew((a)))
#define                     rmColor3DDelete(a) (rmVertex3DDelete((RMvertex3D *)(a)))
RM_EXPORT_API  RMcolor4D   *rmColor4DNew (size_t n);
RM_EXPORT_API  void         rmColor4DDelete (RMcolor4D *to_delete);
RM_EXPORT_API  RMinternalMarker2D *rmInternalMarker2DNew (int nverts, int begin_flag, RMvertex2D *dverts);
RM_EXPORT_API  void         rmInternalMarker2DDelete (RMinternalMarker2D *t);
#define                     rmInternalMarker2DGetNpts(n)	((n)->npts)
#define                     rmInternalMarker2DSetNpts(m,n)	((m)->npts = n)
#define                     rmInternalMarker2DGetVerts(n)	((n)->vlist)
#define                     rmInternalMarker2DSetBFlag(m,f)	((m)->gl_begin_flag = (f))
#define                     rmInternalMarker2DGetBFlag(m)	((m)->gl_begin_flag)
RM_EXPORT_API unsigned char **rmMalloc2DByteBuffer (int width, int height);
RM_EXPORT_API  void         rmFree2DByteBuffer (unsigned char **c);
RM_EXPORT_API  float      **rmMalloc2DFloatBuffer (int width, int height);
RM_EXPORT_API  void         rmFree2DFloatBuffer (float **f);
RM_EXPORT_API unsigned char ***rmMalloc3DByteBuffer (int width, int height, int depth);
RM_EXPORT_API  void         rmFree3DByteBuffer (unsigned char ***c);
RM_EXPORT_API  float     ***rmMalloc3DFloatBuffer (int width, int height, int depth);
RM_EXPORT_API  void         rmFree3DFloatBuffer (float ***c);

/* rmmatrix.c: matrix routines [12] */
RM_EXPORT_API  RMmatrix    *rmMatrixNew (void);
RM_EXPORT_API  RMenum       rmMatrixCopy (RMmatrix *dst, const RMmatrix *src);
RM_EXPORT_API  RMenum       rmMatrixDelete (RMmatrix *toDelete);
RM_EXPORT_API  RMenum       rmMatrixIdentity (RMmatrix *toModify);
RM_EXPORT_API  RMenum       rmMatrixSetValue (RMmatrix *toModify, int row, int col, float newValue);
RM_EXPORT_API  float        rmMatrixGetValue (const RMmatrix *toQuery, int row, int col);
RM_EXPORT_API  RMenum       rmMatrixTranspose (const RMmatrix *src, RMmatrix *dst);
RM_EXPORT_API  RMenum       rmMatrixMultiply (const RMmatrix *srcA, const RMmatrix *srcB, RMmatrix *dst);
RM_EXPORT_API  RMenum       rmMatrixInverse (const RMmatrix *src, RMmatrix *dst);
RM_EXPORT_API  RMenum       rmPoint4MatrixTransform (const float *src, const RMmatrix *matrix, float *dst);
RM_EXPORT_API  RMenum       rmPointMatrixTransform (const RMvertex3D *src, const RMmatrix *m, RMvertex3D *dst);
RM_EXPORT_API  RMenum       rmPrintMatrix (const RMmatrix *toPrint);

/* rmmatrix.c: min/max routines [3] */
RM_EXPORT_API  RMenum       rmPointMin (const float *input, int count, int vdims, int stride, RMvertex3D *minReturn);
RM_EXPORT_API  RMenum       rmPointMax (const float *input, int count, int vdims, int stride, RMvertex3D *maxReturn);
RM_EXPORT_API  RMenum       rmPointMinMax (const float *input, int count, int vdims, int stride, RMvertex3D *minReturn, RMvertex3D *maxReturn);

/* rmmatrix.c: vector routines [11] */
RM_EXPORT_API  double       rmVertex3DMag (const RMvertex3D *v);
RM_EXPORT_API  RMenum       rmVertex3DSum (const RMvertex3D *a, const RMvertex3D *b, RMvertex3D *dst);
RM_EXPORT_API  RMenum       rmVertex3DDiff (const RMvertex3D *a, const RMvertex3D *b, RMvertex3D *dst);
RM_EXPORT_API  double       rmVertex3DDot (const RMvertex3D *a, const RMvertex3D *b);
RM_EXPORT_API  RMenum       rmVertex3DCross (RMvertex3D *p, RMvertex3D *r, RMvertex3D *result);
RM_EXPORT_API  RMenum       rmVertex3DNormalize (RMvertex3D *toNormalize);
RM_EXPORT_API  RMenum       rmVertex3DMagNormalize (RMvertex3D *toNormalize, double *magReturn);
RM_EXPORT_API  RMenum       rmVertex3DMidpoint (const RMvertex3D *a, const RMvertex3D *b, RMvertex3D *dst);
RM_EXPORT_API  RMenum       rmDCFromWC3 (const RMvertex3D *src, RMvertex3D *dst, int nPoints, const RMcamera3D *cam3d, const RMmatrix *model, float viewPort[4], int windowWidth, int windowHeight);
RM_EXPORT_API  RMenum       rmDCFromWC2 (const RMvertex2D *src, RMvertex2D *dst, int nPoints, const RMcamera2D *cam3d, const RMmatrix *model, float viewPort[4], int windowWidth, int windowHeight);

/* rmnode.c: node functions [26] */
RM_EXPORT_API  RMnode      *rmRootNode (void);
RM_EXPORT_API  RMnode      *rmNodeNew (char *name, RMenum renderpassVdims, RMenum renderpassOpaque);
RM_EXPORT_API  RMenum       rmNodeDelete (RMnode *toDelete);
RM_EXPORT_API  RMenum       rmSubTreeDelete (RMnode *toDelete, RMenum deleteRootBool);
RM_EXPORT_API  RMenum       rmNodeSetName (RMnode *toModify, const char *name);
RM_EXPORT_API  char        *rmNodeGetName (const RMnode *toQuery);
RM_EXPORT_API  RMenum       rmNodeSetPickEnable (RMnode *toModify, RMenum newVal);
RM_EXPORT_API  RMenum       rmNodeSetTraverseEnable (RMnode *toModify, RMenum newval);
RM_EXPORT_API  RMenum       rmNodeGetTraverseEnable (const RMnode *toQuery);
RM_EXPORT_API  RMenum       rmNodeGetPickEnable (const RMnode *toQuery);
RM_EXPORT_API  RMenum       rmNodeAddChild (RMnode *parent, RMnode *child);
RM_EXPORT_API  RMenum       rmNodeRemoveChild (RMnode *parent, RMnode *child);
RM_EXPORT_API  RMenum       rmNodeRemoveIthChild (RMnode *parent, int indx);
RM_EXPORT_API  RMenum       rmNodeRemoveAllChildren (RMnode *toModify);
RM_EXPORT_API  RMenum       rmNodeRemoveAllPrims (RMnode *toModify);
RM_EXPORT_API  int          rmNodeGetNumChildren (const RMnode *toQuery);
RM_EXPORT_API  int          rmNodeGetNumPrims (const RMnode *toQuery);
RM_EXPORT_API  RMnode      *rmNodeGetIthChild (const RMnode *toQuery, int indx);
RM_EXPORT_API  RMnode      *rmFindNamedNode (const RMnode *start, const char *name);
RM_EXPORT_API  void         rmSceneGraphWalk (const RMpipe *p, RMnode *r, void (*userfunc)(RMnode *node, const RMstate *s, void *clientData), void *clientData);
RM_EXPORT_API  void         rmPrintSceneGraph (const RMnode *root, RMenum printMode, const char *fileName);
RM_EXPORT_API  RMenum	    rmNodeMutexInit (RMnode *toModify, RMenum lockStatus);
RM_EXPORT_API  RMenum	    rmNodeMutexLock (RMnode *toModify);
RM_EXPORT_API  RMenum	    rmNodeMutexUnlock (RMnode *toModify);
RM_EXPORT_API  RMenum       rmNodeMutexTryLock (const RMnode *toQuery);
RM_EXPORT_API  RMmutex     *rmNodeGetMutex (const RMnode *toQuery);
RM_EXPORT_API  RMenum       rmNodeMutexDelete (RMnode *toModify);

/* rmnode.c: node bounding box stuff [5] */
RM_EXPORT_API  RMenum       rmNodeSetBoundingBox (RMnode *toModify, const RMvertex3D *vMin, const RMvertex3D *vMax);
RM_EXPORT_API  RMenum       rmNodeGetBoundingBox (const RMnode *toQuery, RMvertex3D *vMinReturn, RMvertex3D *vMaxReturn);
RM_EXPORT_API  RMenum       rmNodeComputeCenterFromBoundingBox (RMnode *toModify);
RM_EXPORT_API  RMenum       rmNodeComputeBoundingBox (RMnode *toModify);
RM_EXPORT_API  RMenum       rmNodeUnionAllBoxes (RMnode *toModify);

/* rmnode.c: node material properties [12] */
RM_EXPORT_API  RMenum       rmNodeSetAmbientColor (RMnode *toModify, const RMcolor4D *newColor);
RM_EXPORT_API  RMenum       rmNodeGetAmbientColor (const RMnode *toQuery, RMcolor4D *ambientReturn);
RM_EXPORT_API  RMenum       rmNodeSetDiffuseColor (RMnode *toModify, const RMcolor4D *newColor);
RM_EXPORT_API  RMenum       rmNodeGetDiffuseColor (const RMnode *toQuery, RMcolor4D *diffuseReturn);
RM_EXPORT_API  RMenum       rmNodeSetSpecularColor (RMnode *toModify, const RMcolor4D *newColor);
RM_EXPORT_API  RMenum       rmNodeGetSpecularColor (const RMnode *toQuery, RMcolor4D *diffuseReturn);
RM_EXPORT_API  RMenum       rmNodeSetSpecularExponent (RMnode *toModify, float newValue);
RM_EXPORT_API  RMenum       rmNodeGetSpecularExponent (const RMnode *toQuery, float *retValue);
RM_EXPORT_API  RMenum       rmNodeSetUnlitColor (RMnode *toModify, const RMcolor4D *newColor);
RM_EXPORT_API  RMenum       rmNodeGetUnlitColor (const RMnode *toQuery, RMcolor4D *retColor);
/* deprecated */ RM_EXPORT_API  RMenum rmNodeSetOpacity (RMnode *toModify, float newValue);
/* deprecated */ RM_EXPORT_API  RMenum rmNodeGetOpacity (const RMnode *toQuery, float *retValue);

/* rmnode.c: drawing attributes [16] */
RM_EXPORT_API  RMenum       rmNodeSetNormalizeNormals (RMnode *toModify, RMenum newValue);
RM_EXPORT_API  RMenum       rmNodeGetNormalizeNormals (const RMnode *toQuery, RMenum *retValue);
RM_EXPORT_API  RMenum       rmNodeSetLineStyle (RMnode *toModify, RMenum newStyle);
RM_EXPORT_API  RMenum       rmNodeGetLineStyle (const RMnode *toQuery, RMenum *retStyle);
RM_EXPORT_API  RMenum       rmNodeSetLineWidth (RMnode *toModify, RMenum newWidthEnum);
RM_EXPORT_API  RMenum       rmNodeGetLineWidth (const RMnode *toQuery, RMenum *retWidthEnum);
RM_EXPORT_API  RMenum       rmNodeSetPointSize (RMnode *toModify, float newsize);
RM_EXPORT_API  RMenum       rmNodeGetPointSize (const RMnode *toQuery, float *sizeReturn);
RM_EXPORT_API  RMenum       rmNodeSetShader (RMnode *toModify, RMenum newShaderEnum);
RM_EXPORT_API  RMenum       rmNodeGetShader (const RMnode *toQuery, RMenum *retShaderEnum);
RM_EXPORT_API  RMenum       rmNodeSetPolygonDrawMode (RMnode *toModify, RMenum whichFace, RMenum newMode);
RM_EXPORT_API  RMenum       rmNodeGetPolygonDrawMode (const RMnode *toQuery, RMenum *returnFace, RMenum *returnMode);
RM_EXPORT_API  RMenum       rmNodeSetPolygonCullMode (RMnode *toModify, RMenum newMode);
RM_EXPORT_API  RMenum       rmNodeGetPolygonCullMode (const RMnode *toQuery, RMenum *modeReturn);
RM_EXPORT_API  RMenum       rmNodeSetFrontFace (RMnode *toModify, RMenum newMode);
RM_EXPORT_API  RMenum       rmNodeGetFrontFace (const RMnode *toQuery, RMenum *modeReturn);

/* rmnode.c: traversal mask control [6] */
RM_EXPORT_API  RMenum       rmNodeSetTraversalMaskOpacity (RMnode *toModify,RMenum opacityTraversalMask);
RM_EXPORT_API  RMenum       rmNodeGetTraversalMaskOpacity (const RMnode *toQuery, RMenum *opacityTraversalMaskReturn);
RM_EXPORT_API  RMenum       rmNodeSetTraversalMaskDims (RMnode *n, RMenum dimsTraversalMask);
RM_EXPORT_API  RMenum       rmNodeGetTraversalMaskDims (RMnode *n, RMenum *dimsTraversalMaskReturn);
RM_EXPORT_API  RMenum       rmNodeSetTraversalMaskChannel(RMnode *toModify, RMenum newval);
RM_EXPORT_API  RMenum       rmNodeGetTraversalMaskChannel(const RMnode *toQuery, RMenum *channelTraversalMaskReturn);

/* rmnode.c: node transformations [17] */
RM_EXPORT_API  RMenum       rmNodeSetTransformMode (RMnode *toModify, RMenum newMode);
RM_EXPORT_API  RMenum       rmNodeGetTransformMode (const RMnode *toQuery);
RM_EXPORT_API  RMenum       rmNodeSetPreMatrix (RMnode *toModify, const RMmatrix *newMatrix);
RM_EXPORT_API  RMenum       rmNodeGetPreMatrix (const RMnode *toQuery, RMmatrix *matrixReturn);
RM_EXPORT_API  RMenum       rmNodeSetCenter (RMnode *toModify, const RMvertex3D *newVertex);
RM_EXPORT_API  RMenum       rmNodeGetCenter (const RMnode *toQuery, RMvertex3D *retVector);
RM_EXPORT_API  RMenum       rmNodeSetScaleMatrix (RMnode *toModify, const RMmatrix *newMatrix);
RM_EXPORT_API  RMenum       rmNodeGetScaleMatrix (const RMnode *toQuery, RMmatrix *matrixReturn);
RM_EXPORT_API  RMenum       rmNodeSetRotateMatrix (RMnode *toModify, const RMmatrix *newMatrix);
RM_EXPORT_API  RMenum       rmNodeGetRotateMatrix (const RMnode *toQuery, RMmatrix *matrixReturn);
RM_EXPORT_API  RMenum       rmNodeSetPostRotateScaleMatrix (RMnode *toModify, const RMmatrix *newMatrix);
RM_EXPORT_API  RMenum       rmNodeGetPostRotateScaleMatrix (const RMnode *toQuery, RMmatrix *matrixReturn);
RM_EXPORT_API  RMenum       rmNodeSetTranslateVector (RMnode *toModify, const RMvertex3D *newVector);
RM_EXPORT_API  RMenum       rmNodeGetTranslateVector (const RMnode *toQuery, RMvertex3D *returnVector);
RM_EXPORT_API  RMenum       rmNodeSetPostMatrix (RMnode *toModify, const RMmatrix *newMatrix);
RM_EXPORT_API  RMenum       rmNodeGetPostMatrix (const RMnode *toQuery, RMmatrix *matrixReturn);
RM_EXPORT_API  RMenum       rmNodeGetCompositeModelMatrix (RMnode *toQuery, RMmatrix *transformReturn);

/* rmnode.c: node callbacks [4] */
RM_EXPORT_API  RMenum       rmNodeSetSwitchCallback (RMnode *toModify, int (*appFunc)(const RMnode *, const RMstate *));
RM_EXPORT_API  RMenum       rmNodeSetPreTraversalCallback (RMnode *toModify, RMenum whichPass, int (*appFunc)(const RMnode *, const RMstate *));
RM_EXPORT_API  RMenum       rmNodeSetPostTraversalCallback (RMnode *toModify, RMenum whichPass, int (*appFunc)(const RMnode *, const RMstate *));
RM_EXPORT_API  RMenum       rmNodeSetRenderOrderCallback (RMnode *toModify, int (*appFunc)(const RMnode *, const RMstate *, int *orderIndices, int nChildren));

/* rmnode.c: default view frustum callback */
RM_EXPORT_API int           rmNodeFrustumCullCallback(const RMnode *n, const RMstate *s);

/* rminit.c: init, epilogue [2] */
RM_EXPORT_API  void         rmInit (void);
RM_EXPORT_API  void         rmFinish (void);

/* rmpick.c: picking [7] */
RM_EXPORT_API  RMpick      *rmFramePick (RMpipe *renderPipe, RMnode *subTree, int xpick, int ypick);
RM_EXPORT_API  int          rmFramePickList (RMpipe *renderPipe, RMnode *subTree, int xpick, int ypick, RMpick **listReturn);
RM_EXPORT_API  RMenum       rmPickDelete (RMpick *toDelete);
RM_EXPORT_API  RMnode      *rmPickedNode (const RMpick *toQuery);
RM_EXPORT_API  int          rmPickedPrimitive (const RMpick *toQuery);
RM_EXPORT_API  char        *rmPickedNodeName (const RMpick *toQuery);
RM_EXPORT_API  float        rmPickedPrimitiveZval (const RMpick *toQuery);

/* rmprim.c: primitives [32] */
RM_EXPORT_API  RMprimitive *rmPrimitiveNew (RMenum primType);
RM_EXPORT_API  void         rmPrimitiveDelete (RMprimitive *toDelete);
RM_EXPORT_API  RMenum       rmPrimitiveSetRenderFunc (RMprimitive *toModify, void (*drawFunc) OGLPRIMPARMLIST() );
RM_EXPORT_API  void        *rmPrimitiveGetRenderFunc (const RMprimitive *toQuery);
RM_EXPORT_API  RMenum       rmPrimitiveSetModelFlag (RMprimitive *toModify, int newVal);
RM_EXPORT_API  int          rmPrimitiveGetModelFlag (const RMprimitive *toQuery);
RM_EXPORT_API  RMenum       rmPrimitiveSetBoundingBox(RMprimitive *p, const RMvertex3D *bmin, const RMvertex3D *bmax);
RM_EXPORT_API  RMenum       rmPrimitiveGetBoundingBox(const RMprimitive *p, RMvertex3D *bmin, RMvertex3D *bmax);
RM_EXPORT_API  RMenum       rmPrimitiveComputeBoundingBox (RMprimitive *p);

RM_EXPORT_API  RMenum       rmPrimitiveGetType (const RMprimitive *toQuery);
RM_EXPORT_API  RMenum       rmPrimitiveSetClientData (RMprimitive *toModify, void *clientData, void (*cdFreeFunc)(RMprimitive *, void *));
RM_EXPORT_API  void        *rmPrimitiveGetClientData (const RMprimitive *toQuery);
RM_EXPORT_API  RMenum       rmPrimitiveSetAppDisplayList(RMprimitive *toModify, GLuint displayListID);
RM_EXPORT_API  RMenum       rmPrimitiveSetVertex2D (RMprimitive *toModify, size_t nVertices, RMvertex2D *vertexData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetVertex3D (RMprimitive *toModify, size_t nVertices, RMvertex3D *vertexData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetColor3D (RMprimitive *toModify, size_t nColors, RMcolor3D *colorData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetColor4D (RMprimitive *toModify, size_t nColors, RMcolor4D *colorData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetRadii (RMprimitive *toModify, size_t nRadii, float *radii, RMenum copyEnum, void (*freeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetNormal3D (RMprimitive *toModify, size_t nNormals, RMvertex3D *normalsData, RMenum copyEnum, void (*freeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetTexcoord1D (RMprimitive *toModify, size_t nTexCoords, float *texCoordData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetTexcoord2D (RMprimitive *toModify, size_t nTexCoords, RMvertex2D *texCoordData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetTexcoord3D (RMprimitive *toModify, size_t nTexcoords, RMvertex3D *texCoordData, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetMultiTexcoord1D (RMprimitive *toModify, size_t nTexCoords, float *texCoordData, RMenum copyEnum, void (*appFreeFunc)(void *), int textureUnitIndx);
RM_EXPORT_API  RMenum       rmPrimitiveSetMultiTexcoord2D (RMprimitive *toModify, size_t nTexCoords, RMvertex2D *texCoordData, RMenum copyEnum, void (*appFreeFunc)(void *), int textureUnitIndx);
RM_EXPORT_API  RMenum       rmPrimitiveSetMultiTexcoord3D (RMprimitive *toModify, size_t nTexcoords, RMvertex3D *texCoordData, RMenum copyEnum, void (*appFreeFunc)(void *), int textureUnitIndx);
RM_EXPORT_API  RMenum       rmPrimitiveSetIndices (RMprimitive *toModify, size_t numIndices, int *indicesArray, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetSprites (RMprimitive *toModify, size_t nSprites, RMimage **spriteArray);
RM_EXPORT_API  RMenum       rmPrimitiveSetBitmaps (RMprimitive *toModify, size_t nBitmaps, RMbitmap **bmapArray);
RM_EXPORT_API  RMenum       rmPrimitiveSetQmeshDims (RMprimitive *toModify, int uSize, int vSize);
RM_EXPORT_API  RMenum       rmPrimitiveSetOmeshDims (RMprimitive *toModify, int isize, int jsize, int ksize);
RM_EXPORT_API  RMenum       rmPrimitiveSetOmeshMinMaxGrid (RMprimitive *toModify, const RMvertex3D *gridMin, const RMvertex3D *gridMax);
RM_EXPORT_API  RMenum       rmPrimitiveSetMarkerScale (RMprimitive *toModify, int npts, float *scales, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetMarkerPrims (RMprimitive *toModify, int nMarkerPrims, RMinternalMarker2D **mArray);
RM_EXPORT_API  RMenum       rmPrimitiveSetEllipse2DRotate (RMprimitive *toModify, int nVals, float *rotationValues, RMenum copyEnum, void (*appFreeFunc)(void *));
RM_EXPORT_API  RMenum       rmPrimitiveSetText (RMprimitive *toModify, size_t nStrings, char *strings[]);
RM_EXPORT_API  RMenum       rmPrimitiveSetDisplayListEnable (RMprimitive *toModify, RMenum newMode);

RM_EXPORT_API  RMenum       rmNodeAddPrimitive (RMnode *addTo,  RMprimitive *src);
RM_EXPORT_API  RMprimitive *rmNodeGetPrimitive (const RMnode *toQuery, int indx);
RM_EXPORT_API  RMenum       rmNodeSetClientData (RMnode *toModify, void *clientData, void (*cdFreeFunc)(RMnode *,void *));
    /* tmp fall 2007 */
RM_EXPORT_API  RMenum       rmNodeSetClientDataMT(int whichThread, RMnode *n,void *cd, void (*cd_free_func)(RMnode *,void *));
RM_EXPORT_API  void        *rmNodeGetClientData (const RMnode *toQuery);

/* rmrstate.c: render state interface [13] */
RM_EXPORT_API  RMstate     *rmStateNew (void);
RM_EXPORT_API  void         rmStateDelete (RMstate *toDelete);
RM_EXPORT_API  void         rmStateCopy (const RMstate *src, RMstate *dst);
RM_EXPORT_API  const RMmatrix *rmStateGetModelViewMatrix (const RMstate *toQuery);
RM_EXPORT_API  const RMmatrix *rmStateGetProjectionMatrix (const RMstate *toQuery);
RM_EXPORT_API  RMenum       rmStateGetShader(const RMstate *toQuery);
RM_EXPORT_API  RMenum       rmStateGetPolygonDrawMode(const RMstate *toQuery, RMenum *whichFaceReturn, RMenum *drawModeReturn);
RM_EXPORT_API  RMenum       rmStateGetPolygonCullMode(const RMstate *toQuery, RMenum *cullModeReturn);
RM_EXPORT_API  RMenum       rmStateGetFrontFace(const RMstate *toQuery, RMenum *frontFaceReturn);
RM_EXPORT_API  RMenum       rmStateGetLineWidth(const RMstate *toQuery, RMenum *lineWidthReturn);
RM_EXPORT_API  RMenum       rmStateGetLineStyle(const RMstate *toQuery, RMenum *lineStyleReturn);
RM_EXPORT_API  RMenum       rmStateGetPointSize(const RMstate *toQuery, float *sizeReturn);
RM_EXPORT_API  int          rmStateGetFrameNumber(const RMstate *toQuery);

/* rmscene.c: node scene parameters [30] */
RM_EXPORT_API  RMenum       rmNodeSetSceneBackgroundColor (RMnode *toModify, const RMcolor4D *newColor);
RM_EXPORT_API  RMenum       rmNodeGetSceneBackgroundColor (const RMnode *toQuery, RMcolor4D *returnColor);
RM_EXPORT_API  RMenum       rmNodeSetSceneBackgroundImage (RMnode *toModify, const RMimage *newImageTile);
RM_EXPORT_API  RMenum       rmNodeGetSceneBackgroundImage (const RMnode *toQuery, RMimage **returnImageTile);
RM_EXPORT_API  RMenum       rmNodeSetSceneCamera2D (RMnode *toModify, const RMcamera2D *newCamera);
RM_EXPORT_API  RMenum       rmNodeGetSceneCamera2D (const RMnode *toQuery, RMcamera2D **returnCamera);
RM_EXPORT_API  RMenum       rmNodeSetSceneCamera3D (RMnode *toModify, const RMcamera3D *newCamera);
RM_EXPORT_API  RMenum       rmNodeGetSceneCamera3D (const RMnode *toQuery, RMcamera3D **returnCamera);
RM_EXPORT_API  RMenum       rmNodeSetSceneClipPlane (RMnode *toModify, RMenum clipPlaneEnum, const RMclipPlane *newClipPlane);
RM_EXPORT_API  RMenum       rmNodeGetSceneClipPlane (const RMnode *toQuery, RMenum clipPlaneEnum, RMclipPlane **returnClipPlaneCopy);
RM_EXPORT_API  RMenum       rmNodeSetSceneDepthImage (RMnode *toModify, const RMimage *newDepthImage);
RM_EXPORT_API  RMenum       rmNodeGetSceneDepthImage (const RMnode *toQuery, RMimage **returnDepthImage);
RM_EXPORT_API  RMenum       rmNodeSetSceneDepthValue (RMnode *toModify, const float *newDepthValue);
RM_EXPORT_API  RMenum       rmNodeGetSceneDepthValue (const RMnode *toQuery, float *returnDepthValue);
RM_EXPORT_API  RMenum       rmNodeSetSceneFog (RMnode *toModify, const RMfog *newFog);
RM_EXPORT_API  RMenum       rmNodeGetSceneFog (const RMnode *toQuery, RMfog **returnFog);
RM_EXPORT_API  RMenum       rmNodeSetSceneLight (RMnode *toModify, RMenum whichLightEnum, const RMlight *newLight);
RM_EXPORT_API  RMenum       rmNodeGetSceneLight (const RMnode *toQuery, RMenum whichLightEnum, RMlight **returnLightCopy);
RM_EXPORT_API  RMenum       rmNodeSetSceneLightModel (RMnode *toQuery, const RMlightModel *newLightModel);
RM_EXPORT_API  RMenum       rmNodeGetSceneLightModel (const RMnode *toQuery, RMlightModel **retLightModel);
RM_EXPORT_API  RMenum       rmNodeGetSceneMultiTexture (const RMnode *n, int textureUnitIndx, RMtexture **t);
RM_EXPORT_API  RMenum       rmNodeSetSceneMultiTexture (RMnode *n, RMtexture *t, int textureUnit);

RM_EXPORT_API  RMtextProps *rmTextPropsNew (void);
RM_EXPORT_API  RMenum       rmTextPropsDelete (RMtextProps *t);
RM_EXPORT_API  RMenum       rmNodeSetSceneTextProps (RMnode *toModify, const RMtextProps *newTextProps);
RM_EXPORT_API  RMenum       rmNodeGetSceneTextProps (const RMnode *toQuery, RMtextProps **returnTextProps);
RM_EXPORT_API  RMenum       rmNodeSetSceneTexture (RMnode *toModify, RMtexture *newTexture);
RM_EXPORT_API  RMenum       rmNodeGetSceneTexture (const RMnode *toQuery, RMtexture **returnTexture);
RM_EXPORT_API  RMenum       rmNodeSetSceneViewport (RMnode *toModify, const float *newViewport);
RM_EXPORT_API  RMenum       rmNodeGetSceneViewport (const RMnode *toQuery, float **returnViewport);

/* rmstats.c: scene graph statistics [4] */
RM_EXPORT_API  RMenum      rmStatsComputeDemography (RMnode *r);
RM_EXPORT_API  RMenum      rmStatsPrint(void);
RM_EXPORT_API  RMenum      rmStatsEndTime(void);
RM_EXPORT_API  RMenum      rmStatsStartTime(void);


/* rmsync.c: data synchronization (Fall 2007) */
RM_EXPORT_API  RMenum rmDataSyncSetPolicy(RMenum newPolicy);
RM_EXPORT_API  RMenum rmDataSyncGetPolicy(void);
RM_EXPORT_API  RMenum rmDataSyncSetNthreads(int);
RM_EXPORT_API  int    rmDataSyncGetNthreads(void);
RM_EXPORT_API  RMenum rmSync(void);


/* rmtext.c: text properties [2] */
RM_EXPORT_API  RMenum      rmTextPropsSetAttribs (RMtextProps *toModify, int fontEnum, int sizeEnum, RMenum boldEnum, RMenum italicEnum, RMenum hJustifyEnum, RMenum vJustifyEnum);
RM_EXPORT_API  RMenum      rmTextPropsGetAttribs (const RMtextProps *toQuery, int *fontEnumReturn, int *sizeEnumReturn, RMenum *boldEnumReturn, RMenum *italicEnumReturn, RMenum *hJustifyReturn, RMenum *vJustifyReturn);
/* rmxtext.c: text computation  [1] */
RM_EXPORT_API  RMenum      rmTextGetExtents (const char *string, int fontEnum, int sizeEnum, RMenum boldEnum, RMenum italicEnum, int *widthReturn, int *heightReturn, const RMpipe *renderPipe);

/* rmtime.c: time routines [7] */
RM_EXPORT_API  RMtime     *rmTimeNew(void);
RM_EXPORT_API  RMenum      rmTimeDelete(RMtime *toDelete);
RM_EXPORT_API  RMenum      rmTimeCurrent(RMtime *returnVal);
RM_EXPORT_API  RMenum      rmTimeDifference(const RMtime *startTime, const RMtime *endTime, RMtime *diffTime); 
RM_EXPORT_API  double      rmTimeDifferenceMS(const RMtime *startTime, const RMtime *endTime);
RM_EXPORT_API  RMenum      rmTimeSet(RMtime *toModify, long secs, long usecs);
RM_EXPORT_API  RMenum      rmTimeGet(const RMtime *toQuery, long *returnSecs, long *returnUSecs);
RM_EXPORT_API  RMenum      rmTimeSleep(const RMtime *tSleep);
RM_EXPORT_API  RMenum      rmTimeEncodeMS(RMtime *result, double ms);
RM_EXPORT_API  RMenum      rmTimeDecodeMS(const RMtime *src, double *resultMS);

/* rmtxture.c: texturing routines [14] */
RM_EXPORT_API  RMtexture  *rmTextureNew (int ntdims);
RM_EXPORT_API  RMenum      rmTextureDelete (RMtexture *toDelete, RMenum deleteImagesBool);
RM_EXPORT_API  RMenum      rmTextureSetImages (RMtexture *toModify, RMimage **imageArray, int nimages, int borderWidth);
RM_EXPORT_API  RMenum      rmTextureGetImages (const RMtexture *toQuery, RMimage ***imageArray, int *nimages, int *borderWidth);
RM_EXPORT_API  RMenum      rmTextureSetFilterMode (RMtexture *toModify, GLenum minMode, GLenum magMode);
RM_EXPORT_API  RMenum      rmTextureGetFilterMode (const RMtexture *toQuery, GLenum *minModeReturn, GLenum *magModeReturn);
RM_EXPORT_API  RMenum      rmTextureSetWrapMode (RMtexture *toModify, GLenum wrapMode);
RM_EXPORT_API  RMenum      rmTextureGetWrapMode (const RMtexture *toQuery, GLenum *wrapModeReturn);
RM_EXPORT_API  RMenum      rmTextureSetEnv (RMtexture *toModify, GLenum envMode, const RMcolor4D *blendColor);
RM_EXPORT_API  RMenum      rmTextureGetEnv (const RMtexture *toQuery, GLenum *envModeReturn, RMcolor4D *blendColorReturn);
RM_EXPORT_API  RMenum      rmTextureSetGLTexelFormat (RMtexture *toModify, GLenum internalTexelFormat);
RM_EXPORT_API  RMenum      rmTextureGetGLTexelFormat (const RMtexture *toQuery, GLenum *returnTexelFormat);
RM_EXPORT_API  RMenum      rmTextureGetTextureID (const RMtexture *toQuery, GLuint *returnTextureID);
RM_EXPORT_API  RMenum      rmTextureSetTextureID (RMtexture *toModify, GLuint *textureID);

/* rmutil.c: various utilities [7] */
RM_EXPORT_API  int         rmNearestPowerOfTwo (int n);
RM_EXPORT_API  int         rmIntMagnitude (int m);
RM_EXPORT_API  void        rmHSVtoRGB (float hue, float saturation, float value, float *redReturn, float *greenReturn, float *blueReturn);
RM_EXPORT_API  void        rmRGBtoHSV (float red, float green, float blue, float *hueReturn, float *saturationReturn, float *valueReturn);
RM_EXPORT_API  RMenum      rmUnionBoundingBoxes (const RMvertex3D *s1min, const RMvertex3D *s1max, const RMvertex3D *s2min, const RMvertex3D *s2max, RMvertex3D *dmin, RMvertex3D *dmax);
RM_EXPORT_API  int         rmGLGetError (const char *string);
RM_EXPORT_API  int         rmImageBuildMipmaps (const RMimage *src, RMimage ***mapsReturn, RMenum hardwareEnum, RMpipe *hwPipe);

/* rmx.c or rmw.c: buffer swap [1] */
/* rmSwapBuffers() is deprecated. Use rmPipeSwapBuffers() instead. */
/* RM_EXPORT_API  void rmSwapBuffers (RMpipe *p); */

#ifdef __cplusplus
}
#endif

#endif /* _rmpublic_h */

/* EOF */
