/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmvpub.h,v 1.8 2007/07/22 17:34:37 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.8 $
 * $Log: rmvpub.h,v $
 * Revision 1.8  2007/07/22 17:34:37  wes
 * added build target for mingw
 *
 * Revision 1.7  2005/06/12 21:22:37  wes
 * Removed rmvLOD*Reducer routines (deprecated).
 * Removed unusted parameters from rmvI3VectorCones.
 *
 * Revision 1.6  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.5  2005/01/23 17:17:02  wes
 * Copyright update to 2005.
 *
 * Revision 1.4  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.3  2003/10/15 05:45:28  wes
 * Added a flipNormals parameter to rmvJ3ComputeMeshNormals,
 * rmvJ3MeshSurface and rmvJ3ScatterPoint
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.1  2003/01/16 21:53:42  wes
 * Moved rmv*.h files from include/rmv to their new home in include/rm.
 *
 * Revision 1.6  2002/04/30 19:40:54  wes
 * Updated copyright dates.
 *
 * Revision 1.5  2001/03/31 17:14:02  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.4  2000/12/03 23:20:50  wes
 * Mods to parm list for grid/data funcs for isosurfacing method.
 *
 * Revision 1.3  2000/04/20 17:41:49  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:26  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmvpub_h
#define _rmvpub_h

/*
 * these affect inter-marker scaling.  "absolute" means make
 * the marker "scale" units wide, by god, in world coordinates.
 * "grid_relative" will cause marker width to be computed as the
 * product of "scale" with the inter-grid spacing at that point,
 * in world coords.
 */
#define RMV_MARKERSPACING_ABSOLUTE	0
#define RMV_MARKERSPACING_RELATIVE	1
#define RMV_SCALE_ABSOLUTE		0
#define RMV_SCALE_RELATIVE		1

/* these markers are implemented as actual geometry */
#define RMV_2DMARKER_SQUARE 			0
#define RMV_2DMARKER_CROSS  			1
#define RMV_2DMARKER_X      			2
#define RMV_2DMARKER_NORTHTRIANGLE		3
#define RMV_2DMARKER_BOWTIE 			4
#define RMV_2DMARKER_SOUTHTRIANGLE 		5
#define RMV_2DMARKER_DIAMOND 			6
#define RMV_2DMARKER_NORTHTRIANGLE_FILLED 	7

/* these markers are implemented using the zapf-dingbat font in conjunction with the RM_TEXTCHARS primitive */
#define RMV_ZAPFMARKER_STAR_FILLED         0x048
#define RMV_ZAPFMARKER_STAR_UNFILLED       0x049
#define RMV_ZAPFMARKER_ASTERIX_FILLED      0x051
#define RMV_ZAPFMARKER_ASTERIX_UNFILLED    0x052
#define RMV_ZAPFMARKER_CIRCLE_FILLED       0x06c
#define RMV_ZAPFMARKER_CIRCLE_UNFILLED     0x06d
#define RMV_ZAPFMARKER_SQUARE_FILLED       0x06e
#define RMV_ZAPFMARKER_SQUARE_UNFILLED     0x06f
#define RMV_ZAPFMARKER_UPTRIANGLE_FILLED   0x073
#define RMV_ZAPFMARKER_DOWNTRIANGLE_FILLED 0x074
#define RMV_ZAPFMARKER_CLUBS_FILLED        0x0a8
#define RMV_ZAPFMARKER_DIAMONDS_FILLED     0x0a9
#define RMV_ZAPFMARKER_HEARTS_FILLED       0x0aa
#define RMV_ZAPFMARKER_SPADES_FILLED       0x0ab

/* axes masks */
#define RMV_NOAXIS_OFFSET	0
#define RMV_XAXIS_OFFSET  	1
#define RMV_YAXIS_OFFSET  	2
#define RMV_ZAXIS_OFFSET  	4

/* gridding methods */
#define RMV_GRID2D_BIVARIATE 	0
#define RMV_GRID2D_IDSFFT    	1
#define RMV_GRID2D_KRIGE     	2

/* 2D vis routine defines */
#define RMV_2D_MESH_SURFACE		0
#define RMV_2D_UWIRE			1
#define RMV_2D_VWIRE         		2
#define RMV_2D_IMPULSE       		3
#define RMV_2D_BAR           		4
#define RMV_2D_BAROUTLINE    		5
#define RMV_2D_UHORIZON      		6
#define RMV_2D_VHORIZON      		7
#define RMV_2D_SWIREBOX      		8
#define RMV_2D_SSPHERE       		9
#define RMV_2D_UHORIZON_OUTLINE 	10
#define RMV_2D_VHORIZON_OUTLINE 	11
#define RMV_2D_MESH_SURFACE_OUTLINE 	12
#define RMV_2D_SBOX          		13
#define RMV_2D_SPOINT        		14

#define RMV_2D_MESHVECTOR_BARBS		0
#define RMV_2D_MESHVECTOR_ARROWS 	1
#define RMV_2D_MESHVECTOR_CONES		2

#define RMV_NO_SCALE     		0
#define RMV_LINEAR_SCALE 		1
#define RMV_LOG10_SCALE  		2

#ifdef __cplusplus
extern "C" {
#endif

/* rmvcontour.c: contour generation [1] */
RM_EXPORT_API  void   rmvJ3SliceContour ( RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, int axis_offset_enum, int usize, int vsize, int nlevels, float *levels, RMcolor4D *color_list, RMenum lineWidthEnum, RMenum linestyle_enum, RMnode *node);

/* rmverrplot.c: error bar plotting [1] */
RM_EXPORT_API  RMenum rmvI2ErrorPlot (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appu1func)(int i, void *usrData), void *appDataUsrData, float (*appu2func)(int i, void *usrData), void *appData2UserData, float (*appl1func)(int i, void *usrData), void *appData3UsrData, float (*appl2func)(int i, void *usrData), void *appData4UsrData, float (*appdata2func)(int i, void *usrData), void *appData5UsrData, RMvisMap *vmap, int axis_offset_enum, int npts, RMenum lineWidthEnum, RMenum linestyle_enum, RMnode *n);

/* rmvgrid2d.c: 2D grid routines [1] */
RM_EXPORT_API  void rmv2DSurfaceFit (float *x, float *y, float *d, int npts, RMvertex2D *omin, RMvertex2D *omax, int usize, int vsize, int method, float tweak, float *newdata);

/* rmviso.c: isosurfacing {w = f(x,y,z)} routines [2] */
RM_EXPORT_API  RMenum rmvK3MarchingCubes (RMvertex3D (*appgridfunc)(int i, int j, int k, int isize, int jsize, int ksize, float *baseX, float *baseY, float *baseZ, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, int k, int isize, int jsize, int ksize, float *baseData, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, int k, int isize, int jsize, int ksize, float *baseData, void *usrData), void *appData2UsrData, const RMvisMap *vmap, int iusize, int ivsize, int iwsize, float isolevel, RMnode *output, float *baseX, float *baseY, float *baseZ, float *primaryData, float *secondaryData);
RM_EXPORT_API  RMenum rmvK3MarchingCubesVertsNormals (RMvertex3D (*appgridfunc)(int i, int j, int k, int isize, int jsize, int ksize, float *baseX, float *baseY, float *baseZ, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, int k, int isize, int jsize, int ksize, float *baseData, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, int k, int isize, int jsize, int ksize, float *baseData, void *usrData), void *appData2UsrData, const RMvisMap *vmap, int iusize, int ivsize, int iwsize, float isolevel, RMnode *isoNode, float *baseX, float *baseY, float *baseZ, float *primaryData, float *secondaryData, int *returnNVerts, RMvertex3D **returnVerts, RMvertex3D **returnNormals);

/* rmvmesh.c: 3D scalar visualization [18] */
RM_EXPORT_API  RMenum rmvJ3ComputeMeshNormals (RMvertex3D *v, RMvertex3D *normals, int usize, int vsize, RMenum flipNormalsBool);
RM_EXPORT_API  RMenum rmv3DRuledBox (RMvertex3D *grid_min, RMvertex3D *grid_max, int iusize, int ivsize, int iwsize, RMenum linewidth, RMenum linestyle, RMenum backface_cull_enable, RMnode *output);
RM_EXPORT_API  RMenum rmvJ3Bar (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *appData2UsrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int iusize, int ivsize, float shrink, int scalingEnum, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3BarOutline (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int iusize, int ivsize, float shrink, int scalingEnum, RMenum lineWidthEnum, RMenum linestyle_enum, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3Impulse (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, RMenum lineWidthEnum, RMenum linestyle_enum, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3MeshUOutline (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, RMenum linewidth, RMenum linestyle, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3MeshUHorizon (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, float zerocrossing, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3MeshUHorizonOutline (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, RMenum linewidth, RMenum linestyle, float zeroval, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3MeshVOutline (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int usize, int vsize, RMenum linewidth, RMenum linestyle, RMnode *n);
RM_EXPORT_API  RMenum rmvJ3MeshVHorizon (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, float zerocrossing, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3MeshVHorizonOutline (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, RMenum linewidth, RMenum linestyle, float zerocrossing, RMnode *node);
RM_EXPORT_API  RMenum rmvJ3MeshOutline (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, RMenum linewidth, RMenum linestyle, RMnode *n);
RM_EXPORT_API  RMenum rmvJ3MeshSurface (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int usize, int vsize, RMenum flipNormalsEnum, RMnode *return_node);
RM_EXPORT_API  RMenum rmvJ3ScatterPoint (RMvertex3D (*appgridfunc)(int i, int j, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, int j, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, int j, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int usize, int vsize, RMenum do_normals, RMenum flipNormalsBool, RMnode *n);
RM_EXPORT_API  RMenum rmvI3ScatterCube (RMvertex3D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int npts, float shrink, RMnode *node);
RM_EXPORT_API  RMenum rmvI3ScatterWireCube (RMvertex3D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, float scale, RMenum linewidth, RMenum linestyle, RMnode *n);
RM_EXPORT_API  RMenum rmvI3ScatterSphere (RMvertex3D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npoints, float scale, RMnode *n);
RM_EXPORT_API  RMenum rmvI3ScatterGlyph (RMvertex3D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *vmap, int axis_offset_enum, int npts, RMenum size_enum, RMenum marker_enum, RMnode *n);

/* rmvmeshv.c: 3D vector visualization routines [3] */
RM_EXPORT_API  RMenum rmvI3VectorArrows (RMvertex3D (*gridfunc)(int i, void *usrData), void *appGridUsrData, float (*datafunc)(int i, void *usrData), void *appDataUsrData, float (*data2func)(int i, void *usrData), void *appData2UsrData, RMvertex3D (*vectordata)(int i, void *usrData), void *appVectorUsrData, RMvisMap *map, int axis_offset_enum, int npoints, float scale_value, int scale_type, RMenum linewidth, RMenum linestyle, RMnode *result);
RM_EXPORT_API  RMenum rmvI3VectorBarbs (RMvertex3D (*gridfunc)(int i, void *usrData), void *appGridUsrData, float (*datafunc)(int i, void *usrData), void *appDataUsrData, float (*data2func)(int i, void *usrData), void *appData2UsrData, RMvertex3D (*vectordata)(int i, void *usrData), void *appVectorUsrData, RMvisMap *map, int axis_offset_enum, int npoints, float scale_value, RMenum scale_type, RMenum linewidth, RMenum linestyle, RMnode *result);
RM_EXPORT_API  RMenum rmvI3VectorCones (RMvertex3D (*gridfunc)(int i, void *usrData), void *appGridUsrData, float (*datafunc)(int i, void *usrData), void *appDataUsrData, float (*data2func)(int i, void *usrData), void *appData2UsrData, RMvertex3D (*vectordata)(int i, void *usrData), void *appVectorUsrData, RMvisMap *map, int axis_offset_enum, int npoints, float scale_value, RMenum scale_type, RMnode *result);

/* rmvsignal.c: 2D scalar visualization [9] */
RM_EXPORT_API  RMenum rmvI2AreaFill (RMvertex2D (*appgridfunc)(int i, void *usrData), void *apPGridUsrData, float (*appdatafunc)(int i, void *usrData), void *apPDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, float zeroval, RMnode *n);
RM_EXPORT_API  RMenum rmvI2AreaOutline (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, float zerocrossing, RMenum linewidth_enum, RMenum linestyle_enum, RMnode *n);
RM_EXPORT_API  RMenum rmvI2BarFilled (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, float scale, int scaling_enum, RMnode *n);
RM_EXPORT_API  RMenum rmvI2BarOutline (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, float scale, int scaling_enum, RMenum linewidth, RMenum linestyle, RMnode *n);
RM_EXPORT_API  RMenum rmvI2Impulse (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npoints, RMenum lineWidthEnum, RMenum linestyle_enum, RMnode *n);
RM_EXPORT_API  RMenum rmvI2Polyline (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npoints, RMenum lineWidthEnum, RMenum linestyle_enum, RMnode *n);
RM_EXPORT_API  RMenum rmvI2ScatterGeom (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, float scale, int scaling_enum, int marker_enum, RMnode *n);
RM_EXPORT_API  RMenum rmvI2ScatterGlyph (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, int size_enum, int marker_enum, RMnode *n);
RM_EXPORT_API  RMenum rmvI2Step (RMvertex2D (*appgridfunc)(int i, void *usrData), void *appGridUsrData, float (*appdatafunc)(int i, void *usrData), void *appDataUsrData, float (*appdata2func)(int i, void *usrData), void *appData2UsrData, RMvisMap *map, int axis_offset_enum, int npts, float zerocrossing, RMenum linewidth, RMenum linestyle, RMnode *n);

/* rvutil.c: no public routines */

#ifdef __cplusplus
}
#endif

#endif /* _rmvpub_h */
/* EOF */
