/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmx.h,v 1.7 2005/09/12 04:04:58 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.7 $
 * $Log: rmx.h,v $
 * Revision 1.7  2005/09/12 04:04:58  wes
 * Added RM_EXPORT_API in front of all declarations.
 *
 * Revision 1.6  2005/02/19 16:47:24  wes
 * Distro sync and consolidation.
 *
 * Revision 1.5  2005/01/23 17:17:02  wes
 * Copyright update to 2005.
 *
 * Revision 1.4  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.3  2003/10/03 19:16:17  wes
 * Unified naming changes - use rmPipeSet/GetContext rather than use
 * a platform-specific name.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.10  2003/01/27 05:04:27  wes
 * Changes to RMpipe API and initialization sequence to unify GLX, WGL and CR
 * platforms w/o too much disruption to existing apps.
 *
 * Revision 1.9  2003/01/16 22:21:15  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.8  2002/12/31 00:56:21  wes
 * Cleaned up arch-specific portions of RMpipe to support Chromium.
 *
 * Revision 1.7  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.6  2001/10/15 00:18:24  wes
 * Function prototype for rmPipeSetOffscreenWindow().
 *
 * Revision 1.5  2000/12/03 23:20:22  wes
 * Thread-safety mods.
 *
 * Revision 1.4  2000/05/14 23:36:12  wes
 * Added attrib to RMpipe to allow control over how the OpenGL
 * matrix stack is initialized during rendering.
 *
 * Revision 1.3  2000/04/20 17:41:46  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:24  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmx_h
#define _rmx_h

#ifdef __cplusplus
extern "C" {
#endif


/* rmprivat.h: rasterization of text using X [1] */
RM_EXPORT_API int          rmxBitmapFromText (char *string, int font_enum, int size_enum, int bold_enum, int italic_enum, RMbitmap **bitmap_return);

/* rmx.c: pipes, windows, visuals [16] */
RM_EXPORT_API RMenum       rmxPipeSetDisplay (RMpipe *p, Display *d);
RM_EXPORT_API Display     *rmxPipeGetDisplay (const RMpipe *p);

RM_EXPORT_API RMenum       rmxPipeSetColormap (RMpipe *toModify, const Colormap newCmap);
RM_EXPORT_API Colormap     rmxPipeGetColormap (const RMpipe *pipe);
RM_EXPORT_API Colormap     rmxGetSharableColormap (Display *, XVisualInfo *v);
RM_EXPORT_API RMenum       rmxPipeSetVisual (RMpipe *pipe, XVisualInfo *visual);
RM_EXPORT_API XVisualInfo *rmxPipeGetVisual (const RMpipe *pipe);

RM_EXPORT_API RMenum       rmPipeSetWindow (RMpipe *, Window w, int width, int height);
RM_EXPORT_API RMenum       rmPipeSetOffscreenWindow (RMpipe *, GLXPixmap glxp, int width, int height);
RM_EXPORT_API Window       rmPipeGetWindow (const RMpipe *);
RM_EXPORT_API RMenum       rmPipeSwapBuffersX11 (const RMpipe *);

RM_EXPORT_API GLXContext   rmPipeGetContext (const RMpipe *pipe);
RM_EXPORT_API RMenum       rmPipeSetContext (RMpipe *pipe, const GLXContext context);

#ifdef __cplusplus
}
#endif

#endif /* _rmx_h */
/* EOF */
