/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmdefaults.c,v 1.2 2005/08/06 18:32:38 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.2 $
 * $Log: rmdefaults.c,v $
 * Revision 1.2  2005/08/06 18:32:38  wes
 * Doc updates.
 *
 * Revision 1.1  2005/06/15 02:11:04  wes
 * Initial entry.
 *
 */

/*
 * This file contains variables that are used as defaults elsewhere
 * in OpenRM. Read/Write access to these variables is done through
 * the rmSet* or rmGet* family of routines.
 *
 * To Do:
 * 6/14/05:  put all the variables current value, permissible values, etc.
 * into a more elegant structure to minimize the amount of code needed to
 * maintain. For now, we're using big switch statements.
 */

#include <rm/rm.h>
#include "rmprivat.h"

/* RMnode default values (not a complete list) */
static RMenum nodeDefaultPickTraversalMask = RM_TRUE;
static RMenum nodeDefaultTraversalMask = RM_TRUE;

/* PRIVATE */
static int
private_rmValidateEnum(RMenum target,
		       RMenum *list,
		       int n)
{
    int i;
    for (i=0;i<n;i++)
    {
	if (target == list[i])
	    return 1;
    }
    return 0;
}

/*
 * ----------------------------------------------------
 * @Name rmGetEnum
 @pstart
 RMenum rmGetEnum (RMenum queryTag, RMenum *returnValue)
 @pend

 @astart
 RMenum queryTag - an RMenum value indicating the name of the RM
    attribute to query.
 RMenum *returnValue - a pointer to a caller-supplied RMenum. The
    query result will be copied into this memory.
 @aend

 @dstart

 Use this routine to obtain the current value of an application-settable
 RM default. The current set of defaults that can be set/get by the
 application are described in the documentation for rmSetEnum, and in
 the RM Programming Guide.

 This routine will return RM_CHILL upon successful assignment of the newValue
 value to the named tag. RM_WHACKED is returned upon failure.

 @dend
 * ----------------------------------------------------
 */
RMenum
rmGetEnum(RMenum queryTag,
	  RMenum *returnValue)
{
    RMenum rstat = RM_CHILL;
    
    switch (queryTag)
    {
    case RM_DEFAULT_NODE_PICK_TRAVERSAL_MASK:
	*returnValue = nodeDefaultPickTraversalMask;
	break;
	
    case RM_DEFAULT_NODE_TRAVERSAL_MASK:
	*returnValue = nodeDefaultTraversalMask;
	break;
	
    default:
	rstat = RM_WHACKED;
    }

    return rstat;
}

/*
 * ----------------------------------------------------
 * @Name rmSetEnum
 @pstart
 RMenum rmSetEnum (RMenum setTag, RMenum newValue)
 @pend

 @astart
 RMenum queryTag - an RMenum value indicating the name of the RM
    attribute to modify.
 RMenum newValue - an RMenum value. The queryTag will be set to this value.
 @aend

 @dstart

 Use this routine to assign a new value to application-tunable RM defaults.
 The current set of defaults that can be set by the application are listed
 below, along with their permissible values.

 This routine will return RM_CHILL upon successful assignment of the newValue
 value to the named tag. RM_WHACKED is returned upon failure.

 RMnode attributes:
 
 RM_DEFAULT_NODE_TRAVERSAL_MASK (RM_TRUE/RM_FALSE) - the value of the
    general traversal mask assigned to a node by rmNodeNew().
 RM_DEFAULT_NODE_PICK_TRAVERSAL_MASK (RM_TRUE/RM_FALSE) - the value of the
    pick traversal mask assigned to an RMnode by rmNodeNew().

 
 @dend
 * ----------------------------------------------------
 */
RMenum
rmSetEnum(RMenum setTag,
	  RMenum newValue)
{
    RMenum rstat = RM_CHILL;
    RMenum tf[2] = {RM_TRUE, RM_FALSE};
    
    switch (setTag)
    {
    case RM_DEFAULT_NODE_PICK_TRAVERSAL_MASK:
	if (private_rmValidateEnum(newValue, tf, 2))
	    nodeDefaultPickTraversalMask = newValue;
	else
	    rstat = RM_WHACKED, rmWarning("rmSetEnum: the input newValue tag for RM_DEFAULT_NODE_PICK_TRAVERSAL_MASK is neither RM_TRUE nor RM_FALSE");
	break;
	
    case RM_DEFAULT_NODE_TRAVERSAL_MASK:
	if (private_rmValidateEnum(newValue, tf, 2))
	    nodeDefaultTraversalMask = newValue;
	else
	    rstat = RM_WHACKED, rmWarning("rmSetEnum: the input newValue tag for RM_DEFAULT_NODE_TRAVERSAL_MASK is neither RM_TRUE nor RM_FALSE");
	break;
	
    default:
	rstat = RM_WHACKED;
    }

    return rstat;
}

/* EOF */
