/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmpthrd.h,v 1.1 2005/02/19 16:36:40 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.1 $
 * $Log: rmpthrd.h,v $
 * Revision 1.1  2005/02/19 16:36:40  wes
 * Distro merge and consolidation.
 *
 */
#ifndef __rmpthrd_h
#define __rmpthrd_h
/*
 * The purpose of this header file is to create "fake" definitions for
 * Posix Threads routines used by RM/OpenRM. This header file is included
 * from RM/OpenRM code if the compile flag -D_NO_PTHREADS is set. If
 * _NO_PTHREADS is set, RM/OpenRM will not support multithreaded rendering,
 * and is not guaranteed to support thread-safe operation (read or write
 * access to the scene graph by multiple application threads).
 *
 * According to the pthreads man pages:
 * 1. mutexes - pthread_mutex_init always returns 0, other mutex routines
 *    return 0 on success and 1 on failure.
 * 2. cond variables - all condition variable routines return 0 on success
 *    and 1 on failure. pthread_cond_init never returns an error.
 */
#ifndef _POSIX_THREADS
typedef int pthread_mutexattr_t;
typedef int pthread_attr_t;
#endif

#define pthread_mutex_init(a,b)   (0)
#define pthread_mutex_destroy(a)  (0)
#define pthread_mutex_lock(a)     (0)
#define pthread_mutex_unlock(a)   (0)
#define pthread_mutexattr_setkind_np(a,b) (0)
#define pthread_mutex_trylock(a)  (0)
#define pthread_mutexattr_init(a) (0)

#define pthread_cond_init(a,b)    (0)
#define pthread_cond_destroy(a)   (0)
#define pthread_cond_broadcast(a) (0)
#define pthread_setcancelstate(a,b) (0)
#define pthread_cond_wait(a,b)    (0)

#define pthread_attr_init(a)      (0)
#define pthread_attr_setdetachstate(a,b) (0)
#define pthread_create(a,b,c,d)   (0)
#define pthread_join(a,b)         (0)

#define pthread_setconcurrency(a) (0)

#endif
/* EOF */
