/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmvmarker2d.c,v 1.5 2005/02/19 16:09:13 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.5 $
 * $Log: rmvmarker2d.c,v $
 * Revision 1.5  2005/02/19 16:09:13  wes
 * Distro sync and consolidation.
 *
 * Revision 1.4  2005/01/23 17:11:02  wes
 * Copyright updated to 2005.
 *
 * Revision 1.3  2004/01/17 04:09:26  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:23  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.5  2003/01/16 22:21:20  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.4  2002/04/30 19:40:21  wes
 * Updated copyright dates.
 *
 * Revision 1.3  2001/03/31 17:10:08  wes
 * v1.4.0-alpha-2 checkin.
 *
 * Revision 1.2  2000/04/20 16:17:45  wes
 * JDB modifications: code rearrangement, additional docs.
 *
 * Revision 1.1  2000/04/17 00:05:24  wes
 * Lots of documentation updates, courtesy of jdb.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#include <rm/rm.h>
#include <rm/rmv.h>

/* PRIVATE */
void
private_rmv2DMarkerOutlineFunc (RMvertex2D *input,
			        RMvertex2D *output,
			        float *scale,
			        int n,
			        RMvertex2D *shape,
			        int *index)
{
     int                  i;
     register int         lindex;
     float                delta;
     register RMvertex2D *d, *s;

     delta = *scale * 0.5;
     lindex = *index;

     d = output;
     s = input;

     for (i = 0; i < n; i++)
     {
         d[lindex].x = s->x + delta*shape[i].x;
	 d[lindex].y = s->y + delta*shape[i].y;
	 lindex++;
     }
     *index = lindex;
}


/* PRIVATE */
void
private_rmv2DMarkerFilledFunc (RMvertex2D *input,
			       RMvertex2D *output,
			       float *scale,
			       int n,
			       RMvertex2D *shape,
			       int *index)
{
     int                  i;
     register int         lindex;
     float                delta;
     register RMvertex2D *d, *s;

     delta = *scale * 0.5;
     lindex = *index;

     d = output;
     s = input;

     for (i = 0; i < n; i++)
     {
         d[lindex].x = s->x + delta*shape[i].x;
	 d[lindex].y = s->y + delta*shape[i].y;
	 lindex++;
     }
     *index = lindex;
}
/* EOF */
