/*
 * Copyright (C) 1997-2009, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 *   http://www.r3vis.com/
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmvprivt.h,v 1.7 2007/07/22 17:37:17 wes Exp $
 * Version: $Name: v180-alpha-02 $
 * $Revision: 1.7 $
 * $Log: rmvprivt.h,v $
 * Revision 1.7  2007/07/22 17:37:17  wes
 * Adding usrData and usrCallback parameters to all rmv routines
 *
 * Revision 1.6  2005/02/19 16:09:13  wes
 * Distro sync and consolidation.
 *
 * Revision 1.5  2005/02/12 00:34:08  wes
 * Removed archaic PROTO() macros around function declarations.
 *
 * Revision 1.4  2005/01/23 17:11:02  wes
 * Copyright updated to 2005.
 *
 * Revision 1.3  2004/01/17 04:09:26  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:23  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.6  2003/01/16 22:21:20  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.5  2002/04/30 19:40:21  wes
 * Updated copyright dates.
 *
 * Revision 1.4  2001/03/31 17:10:08  wes
 * v1.4.0-alpha-2 checkin.
 *
 * Revision 1.3  2000/04/20 16:17:45  wes
 * JDB modifications: code rearrangement, additional docs.
 *
 * Revision 1.2  2000/02/29 23:43:59  wes
 * Compile warning cleanups.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */


#include <rm/rm.h>
#include <rm/rmv.h>

#ifndef _rmv_rmvprivate_h_
#define _rmv_rmvprivate_h_

int        private_rmAssert (const void *a, const char *s);

#ifndef RM_ASSERT
#define RM_ASSERT(a,s) private_rmAssert((const void *)(a),(const char *)(s))
#endif

#define RMV_LOD1_MAXPOINTS 256


void private_rmv2DMarkerOutlineFunc (RMvertex2D *input,RMvertex2D *output,float *scale,int n,RMvertex2D *shape,int *index);

void private_rmv2DMarkerFilledFunc (RMvertex2D *input,RMvertex2D *output,float *scale,int n,RMvertex2D *shape,int *index);

void private_rmvScaleMagnitude (double *dmag,int scale_type,float scale_value);

void private_rmvInsertZeroCrossings (float *a,int n,float *oldx,float *oldy,float *oldz,float *old_data2,float **newdata,float **newx,float **newy,float **newz,int *m,float **new_data2, float zc);

int idsfft_ (int *md,int *ncp,int *ndp,float *xd,float *yd,float *zd,int *nxi,int *nyi,float *xi,float *yi,float *zi, int *iwk, float *wk);

int idbvip_ (int *md,int *ncp,int *ndp,float *xd,float *yd,float *zd,int *nip, float *xi,	float *yi, float *zi, int *iwk, float *wk);

void rmvLOD1MeshReducer (float *xcoords,float *ycoords,float *zcoords, float *data, float *data2, RMvisMap *vmap, int axis_offset_flag, int mesh_dims[2],  RMnode *n);

void private_rmvSetBox (RMnode *node);
void rmvLOD2MeshReducer (RMvertex3D *bmin, RMvertex3D *bmax, RMnode *);

void private_AxisAlignedWireBox (RMvertex3D *bmin, RMvertex3D *bmax, RMvertex3D *v,  int *rindex,  RMcolor4D *src,  RMcolor4D *dst);

void private_rmvComputeHorizonNormals (RMvertex3D *v, RMvertex3D *norms,int n);

#endif /* _rmv_rmvprivate_h_ */
/* EOF */
