// import required java packages
import net.sf.jasperreports.engine.*;
import net.sf.jasperreports.engine.export.JRPdfExporter;

import java.io.File;
import java.util.Map;
import java.util.HashMap;

import com.aspose.barcode.jr.BarCodeAttributes;

// This example uses custom class "MyAttributes"
// You may edit this class to include more barcode attributes
public class CustomAttributesExample {
    final static String PATH = "";
    public static void main(String[] args){
		String jrxmlFileName = PATH + "CustomBarCodeAttribures.jrxml";
		String fillFileName =PATH + "CustomBarCodeAttribures.jasper";

		try
		{
			// compile the jrxml file 
			JasperCompileManager.compileReportToFile(jrxmlFileName,fillFileName);
			System.out.println("File compiled successfully.");

			File reportFile = new File(fillFileName);

			// set the attributes
			Map<String,BarCodeAttributes> parameters = new HashMap<String, BarCodeAttributes>();
			parameters.put("barCodeAttributes1", new BarCodeAttributes("123456","code11"));
			parameters.put("barCodeAttributes2", new BarCodeAttributes("520168","PDF417"));
			parameters.put("barCodeAttributes3", new BarCodeAttributes("888888","code128"));

			JasperPrint jasperPrint =
				JasperFillManager.fillReport(
					fillFileName,
					parameters,
					new JREmptyDataSource()
					);

			// export the report in pdf format
			JRPdfExporter exporter = new JRPdfExporter();
            File destFile = new File(reportFile.getParent() , jasperPrint.getName() + ".pdf");
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
			exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, destFile.toString());
			exporter.exportReport();

            System.out.println("Report exported to " + destFile.getAbsolutePath() );
			System.out.println("Finished.");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
}
