import java.io.File;

import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;

// This example renders barcodes from a datasource.
// We used a custom class "WebAppDataSource", which is inherited from "JRDataSource"
// ID column of the datasource is set as codetext for barcode generation
public class DataSourceExample {
    final static String PATH = "";
    public static void main(String[] args){
        
        String jrxmlFileName = PATH + "DataSource.jrxml";
		String fillFileName =PATH + "DataSource.jasper";
		
		try
		{
			// compile the jrxml file
			JasperCompileManager.compileReportToFile(jrxmlFileName,fillFileName);
			System.out.println("File compiled successfully!");

			File reportFile = new File(fillFileName);
			
			// apply the datasource
			JasperPrint jasperPrint = 
				JasperFillManager.fillReport(
					fillFileName, 
					null, 
					new WebappDataSource()//JREmptyDataSource()
					);
			
			// export the report in pdf format
			JRPdfExporter exporter = new JRPdfExporter();
			File destFile = new File(reportFile.getParent(), jasperPrint.getName() + ".pdf");
			exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
			exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, destFile.toString());
			exporter.exportReport();
			
			System.out.println("Report exported to " + destFile.getAbsolutePath() );
			System.out.println("Finished.");
		}catch(Exception e){
			e.printStackTrace();
		}
	}
}
