import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;


import com.aspose.barcode.jr.BarCodeAttributes;

// This class is our datasource
// We get records from this datasource, and populate the report with all the records
// It is inherited from JRDataSource class 
public class WebappDataSource implements JRDataSource
{
	private int index = -1;
	private String Symbology = "";
	private Object[][] data = 
		{
			{ new Integer(22), "Bill Ott", "250 - 20th Ave."},
			{ new Integer(9), "James Schneider", "277 Seventh Av."},
			{ new Integer(32), "Michael Ott", "339 College Av."},
			{ new Integer(23), "Julia Heiniger", "358 College Av."},
			{ new Integer(39), "Mary Karsen", "202 College Av."},
			{ new Integer(35), "George Karsen", "412 College Av."},
			{ new Integer(11), "Julia White", "412 Upland Pl."},
			{ new Integer(47), "Janet Fuller", "445 Upland Pl."},
			{ new Integer(43), "Susanne Smith", "2 Upland Pl."},
			{ new Integer(40), "Susanne Miller", "440 - 20th Ave."},
			{ new Integer(36), "John Steel", "276 Upland Pl."},
			{ new Integer(37), "Michael Clancy", "19 Seventh Av."},
			{ new Integer(19), "Susanne Heiniger", "86 - 20th Ave."},
			{ new Integer(10), "Anne Fuller", "135 Upland Pl."},
			{ new Integer(4), "Sylvia Ringer", "365 College Av."},
			{ new Integer(0), "Laura Steel", "429 Seventh Av."},
			{ new Integer(38), "Andrew Heiniger", "347 College Av."},
			{ new Integer(28), "Susanne White", "74 - 20th Ave."},
			{ new Integer(17), "Laura Ott", "443 Seventh Av."},
			{ new Integer(2), "Anne Miller", "20 Upland Pl."},
			{ new Integer(46), "Andrew May", "172 Seventh Av."},
			{ new Integer(44), "Sylvia Ott", "361 College Av."},
			{ new Integer(41), "Bill King", "546 College Av."},
			{ new Integer(45), "Janet May", "396 Seventh Av."},
			{ new Integer(42), "Robert Ott", "503 Seventh Av."},
			{ new Integer(25), "Sylvia Steel", "269 College Av."},
			{ new Integer(18), "Sylvia Fuller", "158 - 20th Ave."},
			{ new Integer(5), "Laura Miller", "294 Seventh Av."},
			{ new Integer(48), "Robert White", "549 Seventh Av."},
			{ new Integer(7), "James Peterson", "231 Upland Pl."}
		};


	public WebappDataSource()
	{
		Symbology = "code128";
	}


	/**
	 *
	 */
	public boolean next() throws JRException
	{
		index++;

		return (index < data.length);
	}


	/**
	 *
	 */
	public Object getFieldValue(JRField field) throws JRException
	{
		Object value = null;
		
		String fieldName = field.getName().toLowerCase();
		
		if ("id".toLowerCase().equalsIgnoreCase(fieldName))
		{
			value = new BarCodeAttributes("" + data[index][0],Symbology);
		}
		else if ("name".toLowerCase().equalsIgnoreCase(fieldName))
		{
			value = data[index][1];
		}
		else if ("address".toLowerCase().equalsIgnoreCase(fieldName))
		{
			value = data[index][2];
		}
		
		return value;
	}


}
