/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr.retro.edu.emory.mathcs.backport.java.util.concurrent;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class TimeUnit
implements Serializable {
    public static final TimeUnit NANOSECONDS = new TimeUnit(0, "NANOSECONDS"){
        private static final long serialVersionUID = 535148490883208361L;

        public long toNanos(long d2) {
            return d2;
        }

        public long toMicros(long d2) {
            return d2 / 1000L;
        }

        public long toMillis(long d2) {
            return d2 / 1000000L;
        }

        public long toSeconds(long d2) {
            return d2 / 1000000000L;
        }

        public long toMinutes(long d2) {
            return d2 / 60000000000L;
        }

        public long toHours(long d2) {
            return d2 / 3600000000000L;
        }

        public long toDays(long d2) {
            return d2 / 86400000000000L;
        }

        public long convert(long d2, TimeUnit u2) {
            return u2.toNanos(d2);
        }

        int excessNanos(long d2, long m2) {
            return (int)(d2 - m2 * 1000000L);
        }
    };
    public static final TimeUnit MICROSECONDS = new TimeUnit(1, "MICROSECONDS"){
        private static final long serialVersionUID = 2185906575929579108L;

        public long toNanos(long d2) {
            return 2.x(d2, 1000L, 9223372036854775L);
        }

        public long toMicros(long d2) {
            return d2;
        }

        public long toMillis(long d2) {
            return d2 / 1000L;
        }

        public long toSeconds(long d2) {
            return d2 / 1000000L;
        }

        public long toMinutes(long d2) {
            return d2 / 60000000L;
        }

        public long toHours(long d2) {
            return d2 / 3600000000L;
        }

        public long toDays(long d2) {
            return d2 / 86400000000L;
        }

        public long convert(long d2, TimeUnit u2) {
            return u2.toMicros(d2);
        }

        int excessNanos(long d2, long m2) {
            return (int)(d2 * 1000L - m2 * 1000000L);
        }
    };
    public static final TimeUnit MILLISECONDS = new TimeUnit(2, "MILLISECONDS"){
        private static final long serialVersionUID = 9032047794123325184L;

        public long toNanos(long d2) {
            return 3.x(d2, 1000000L, 9223372036854L);
        }

        public long toMicros(long d2) {
            return 3.x(d2, 1000L, 9223372036854775L);
        }

        public long toMillis(long d2) {
            return d2;
        }

        public long toSeconds(long d2) {
            return d2 / 1000L;
        }

        public long toMinutes(long d2) {
            return d2 / 60000L;
        }

        public long toHours(long d2) {
            return d2 / 3600000L;
        }

        public long toDays(long d2) {
            return d2 / 86400000L;
        }

        public long convert(long d2, TimeUnit u2) {
            return u2.toMillis(d2);
        }

        int excessNanos(long d2, long m2) {
            return 0;
        }
    };
    public static final TimeUnit SECONDS = new TimeUnit(3, "SECONDS"){
        private static final long serialVersionUID = 227755028449378390L;

        public long toNanos(long d2) {
            return 4.x(d2, 1000000000L, 9223372036L);
        }

        public long toMicros(long d2) {
            return 4.x(d2, 1000000L, 9223372036854L);
        }

        public long toMillis(long d2) {
            return 4.x(d2, 1000L, 9223372036854775L);
        }

        public long toSeconds(long d2) {
            return d2;
        }

        public long toMinutes(long d2) {
            return d2 / 60L;
        }

        public long toHours(long d2) {
            return d2 / 3600L;
        }

        public long toDays(long d2) {
            return d2 / 86400L;
        }

        public long convert(long d2, TimeUnit u2) {
            return u2.toSeconds(d2);
        }

        int excessNanos(long d2, long m2) {
            return 0;
        }
    };
    public static final TimeUnit MINUTES = new TimeUnit(4, "MINUTES"){
        private static final long serialVersionUID = 1827351566402609187L;

        public long toNanos(long d2) {
            return 5.x(d2, 60000000000L, 153722867L);
        }

        public long toMicros(long d2) {
            return 5.x(d2, 60000000L, 153722867280L);
        }

        public long toMillis(long d2) {
            return 5.x(d2, 60000L, 153722867280912L);
        }

        public long toSeconds(long d2) {
            return 5.x(d2, 60L, 0x222222222222222L);
        }

        public long toMinutes(long d2) {
            return d2;
        }

        public long toHours(long d2) {
            return d2 / 60L;
        }

        public long toDays(long d2) {
            return d2 / 1440L;
        }

        public long convert(long d2, TimeUnit u2) {
            return u2.toMinutes(d2);
        }

        int excessNanos(long d2, long m2) {
            return 0;
        }
    };
    public static final TimeUnit HOURS = new TimeUnit(5, "HOURS"){
        private static final long serialVersionUID = -6438436134732089810L;

        public long toNanos(long d2) {
            return 6.x(d2, 3600000000000L, 2562047L);
        }

        public long toMicros(long d2) {
            return 6.x(d2, 3600000000L, 2562047788L);
        }

        public long toMillis(long d2) {
            return 6.x(d2, 3600000L, 2562047788015L);
        }

        public long toSeconds(long d2) {
            return 6.x(d2, 3600L, 2562047788015215L);
        }

        public long toMinutes(long d2) {
            return 6.x(d2, 60L, 0x222222222222222L);
        }

        public long toHours(long d2) {
            return d2;
        }

        public long toDays(long d2) {
            return d2 / 24L;
        }

        public long convert(long d2, TimeUnit u2) {
            return u2.toHours(d2);
        }

        int excessNanos(long d2, long m2) {
            return 0;
        }
    };
    public static final TimeUnit DAYS = new TimeUnit(6, "DAYS"){
        private static final long serialVersionUID = 567463171959674600L;

        public long toNanos(long d2) {
            return 7.x(d2, 86400000000000L, 106751L);
        }

        public long toMicros(long d2) {
            return 7.x(d2, 86400000000L, 106751991L);
        }

        public long toMillis(long d2) {
            return 7.x(d2, 86400000L, 106751991167L);
        }

        public long toSeconds(long d2) {
            return 7.x(d2, 86400L, 106751991167300L);
        }

        public long toMinutes(long d2) {
            return 7.x(d2, 1440L, 0x16C16C16C16C16L);
        }

        public long toHours(long d2) {
            return 7.x(d2, 24L, 0x555555555555555L);
        }

        public long toDays(long d2) {
            return d2;
        }

        public long convert(long d2, TimeUnit u2) {
            return u2.toDays(d2);
        }

        int excessNanos(long d2, long m2) {
            return 0;
        }
    };
    private static final TimeUnit[] values = new TimeUnit[]{NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS};
    private final int index;
    private final String name;
    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;
    static final long MAX = Long.MAX_VALUE;

    public static TimeUnit[] values() {
        return (TimeUnit[])values.clone();
    }

    public static TimeUnit valueOf(String name) {
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (!TimeUnit.values[i2].name.equals(name)) continue;
            return values[i2];
        }
        throw new IllegalArgumentException("No enum const TimeUnit." + name);
    }

    TimeUnit(int index, String name) {
        this.index = index;
        this.name = name;
    }

    static long x(long d2, long m2, long over) {
        if (d2 > over) {
            return Long.MAX_VALUE;
        }
        if (d2 < -over) {
            return Long.MIN_VALUE;
        }
        return d2 * m2;
    }

    public abstract long convert(long var1, TimeUnit var3);

    public abstract long toNanos(long var1);

    public abstract long toMicros(long var1);

    public abstract long toMillis(long var1);

    public abstract long toSeconds(long var1);

    public abstract long toMinutes(long var1);

    public abstract long toHours(long var1);

    public abstract long toDays(long var1);

    abstract int excessNanos(long var1, long var3);

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.index;
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return TimeUnit.valueOf(this.name);
        }
        catch (IllegalArgumentException e2) {
            throw new InvalidObjectException(this.name + " is not a valid enum for TimeUnit");
        }
    }

    public void timedWait(Object obj, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms2 = this.toMillis(timeout);
            int ns2 = this.excessNanos(timeout, ms2);
            obj.wait(ms2, ns2);
        }
    }

    public void timedJoin(Thread thread, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms2 = this.toMillis(timeout);
            int ns2 = this.excessNanos(timeout, ms2);
            thread.join(ms2, ns2);
        }
    }

    public void sleep(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms2 = this.toMillis(timeout);
            int ns2 = this.excessNanos(timeout, ms2);
            Thread.sleep(ms2, ns2);
        }
    }

    public String toString() {
        return this.name;
    }
}

